"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formatErrors = void 0;
var Option = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("effect/Option"));
var ReadonlyArray = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("effect/ReadonlyArray"));
var _TreeFormatter = /*#__PURE__*/require("./TreeFormatter.js");
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/**
 * @since 1.0.0
 */

const format = (self, path = []) => {
  const _tag = self._tag;
  switch (_tag) {
    case "Type":
      return [{
        _tag,
        path,
        message: (0, _TreeFormatter.getMessage)(self)
      }];
    case "Key":
      return ReadonlyArray.flatMap(self.errors, e => format(e, [...path, self.key]));
    case "Index":
      return ReadonlyArray.flatMap(self.errors, e => format(e, [...path, self.index]));
    case "UnionMember":
      return ReadonlyArray.flatMap(self.errors, e => format(e, path));
    case "Missing":
      return [{
        _tag,
        path,
        message: "Missing key or index"
      }];
    case "Forbidden":
      return [{
        _tag,
        path,
        message: "Forbidden"
      }];
    case "Unexpected":
      return [{
        _tag,
        path,
        message: "Unexpected" + (Option.isSome(self.ast) ? `, expected ${(0, _TreeFormatter.formatExpected)(self.ast.value)}` : "")
      }];
  }
};
/**
 * @category formatting
 * @since 1.0.0
 */
const formatErrors = errors => ReadonlyArray.flatMap(errors, e => format(e));
exports.formatErrors = formatErrors;
//# sourceMappingURL=ArrayFormatter.js.map