"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.voidKeyword = exports.unknownKeyword = exports.undefinedKeyword = exports.to = exports.symbolKeyword = exports.stringKeyword = exports.setAnnotation = exports.required = exports.rename = exports.pick = exports.partial = exports.omit = exports.objectKeyword = exports.numberKeyword = exports.neverKeyword = exports.mutable = exports.mergeAnnotations = exports.keyof = exports.isVoidKeyword = exports.isUnknownKeyword = exports.isUniqueSymbol = exports.isUnion = exports.isUndefinedKeyword = exports.isTypeLiteralTransformation = exports.isTypeLiteral = exports.isTuple = exports.isTransform = exports.isTemplateLiteral = exports.isSymbolKeyword = exports.isSuspend = exports.isStringKeyword = exports.isRefinement = exports.isParameter = exports.isObjectKeyword = exports.isNumberKeyword = exports.isNeverKeyword = exports.isLiteral = exports.isFinalTransformation = exports.isFinalPropertySignatureTransformation = exports.isEnums = exports.isDeclaration = exports.isComposeTransformation = exports.isBooleanKeyword = exports.isBigIntKeyword = exports.isAnyKeyword = exports.getWeight = exports.getToPropertySignatures = exports.getToIndexSignatures = exports.getTitleAnnotation = exports.getPropertySignatures = exports.getParameterBase = exports.getMessageAnnotation = exports.getJSONSchemaAnnotation = exports.getIdentifierAnnotation = exports.getExamplesAnnotation = exports.getDescriptionAnnotation = exports.getDefaultAnnotation = exports.getCompiler = exports.getCardinality = exports.getAnnotation = exports.from = exports.createUniqueSymbol = exports.createUnion = exports.createTypeLiteralTransformation = exports.createTypeLiteral = exports.createTuple = exports.createTransform = exports.createTemplateLiteral = exports.createSuspend = exports.createRefinement = exports.createRecord = exports.createPropertySignatureTransform = exports.createPropertySignature = exports.createLiteral = exports.createIndexSignature = exports.createFinalTransformation = exports.createFinalPropertySignatureTransformation = exports.createEnums = exports.createElement = exports.createDeclaration = exports.composeTransformation = exports.compose = exports.booleanKeyword = exports.bigIntKeyword = exports.appendRestElement = exports.appendElement = exports.anyKeyword = exports._null = exports.TypeAnnotationId = exports.TitleAnnotationId = exports.MessageAnnotationId = exports.JSONSchemaAnnotationId = exports.IdentifierAnnotationId = exports.ExamplesAnnotationId = exports.DocumentationAnnotationId = exports.DescriptionAnnotationId = exports.DefaultAnnotationId = exports.BrandAnnotationId = void 0;
var _Function = /*#__PURE__*/require("effect/Function");
var Number = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("effect/Number"));
var Option = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("effect/Option"));
var Order = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("effect/Order"));
var Predicate = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("effect/Predicate"));
var ReadonlyArray = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("effect/ReadonlyArray"));
var Internal = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./internal/ast.js"));
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/**
 * @since 1.0.0
 */

/**
 * @category annotations
 * @since 1.0.0
 */
const BrandAnnotationId = exports.BrandAnnotationId = /*#__PURE__*/Symbol.for("@effect/schema/annotation/Brand");
/**
 * @category annotations
 * @since 1.0.0
 */
const TypeAnnotationId = exports.TypeAnnotationId = /*#__PURE__*/Symbol.for("@effect/schema/annotation/Type");
/**
 * @category annotations
 * @since 1.0.0
 */
const MessageAnnotationId = exports.MessageAnnotationId = /*#__PURE__*/Symbol.for("@effect/schema/annotation/Message");
/**
 * @category annotations
 * @since 1.0.0
 */
const IdentifierAnnotationId = exports.IdentifierAnnotationId = /*#__PURE__*/Symbol.for("@effect/schema/annotation/Identifier");
/**
 * @category annotations
 * @since 1.0.0
 */
const TitleAnnotationId = exports.TitleAnnotationId = /*#__PURE__*/Symbol.for("@effect/schema/annotation/Title");
/**
 * @category annotations
 * @since 1.0.0
 */
const DescriptionAnnotationId = exports.DescriptionAnnotationId = /*#__PURE__*/Symbol.for("@effect/schema/annotation/Description");
/**
 * @category annotations
 * @since 1.0.0
 */
const ExamplesAnnotationId = exports.ExamplesAnnotationId = /*#__PURE__*/Symbol.for("@effect/schema/annotation/Examples");
/**
 * @category annotations
 * @since 1.0.0
 */
const DefaultAnnotationId = exports.DefaultAnnotationId = /*#__PURE__*/Symbol.for("@effect/schema/annotation/Default");
/**
 * @category annotations
 * @since 1.0.0
 */
const JSONSchemaAnnotationId = exports.JSONSchemaAnnotationId = /*#__PURE__*/Symbol.for("@effect/schema/annotation/JSONSchema");
/**
 * @category annotations
 * @since 1.0.0
 */
const DocumentationAnnotationId = exports.DocumentationAnnotationId = /*#__PURE__*/Symbol.for("@effect/schema/annotation/Documentation");
/**
 * @category annotations
 * @since 1.0.0
 */
const getAnnotation = exports.getAnnotation = /*#__PURE__*/(0, _Function.dual)(2, (annotated, key) => Object.prototype.hasOwnProperty.call(annotated.annotations, key) ? Option.some(annotated.annotations[key]) : Option.none());
/**
 * @category annotations
 * @since 1.0.0
 */
const getMessageAnnotation = exports.getMessageAnnotation = /*#__PURE__*/getAnnotation(MessageAnnotationId);
/**
 * @category annotations
 * @since 1.0.0
 */
const getTitleAnnotation = exports.getTitleAnnotation = /*#__PURE__*/getAnnotation(TitleAnnotationId);
/**
 * @category annotations
 * @since 1.0.0
 */
const getIdentifierAnnotation = exports.getIdentifierAnnotation = /*#__PURE__*/getAnnotation(IdentifierAnnotationId);
/**
 * @category annotations
 * @since 1.0.0
 */
const getDescriptionAnnotation = exports.getDescriptionAnnotation = /*#__PURE__*/getAnnotation(DescriptionAnnotationId);
/**
 * @category annotations
 * @since 1.0.0
 */
const getExamplesAnnotation = exports.getExamplesAnnotation = /*#__PURE__*/getAnnotation(ExamplesAnnotationId);
/**
 * @category annotations
 * @since 1.0.0
 */
const getDefaultAnnotation = exports.getDefaultAnnotation = /*#__PURE__*/getAnnotation(DefaultAnnotationId);
/**
 * @category annotations
 * @since 1.0.0
 */
const getJSONSchemaAnnotation = exports.getJSONSchemaAnnotation = /*#__PURE__*/getAnnotation(JSONSchemaAnnotationId);
/**
 * @category constructors
 * @since 1.0.0
 */
const createDeclaration = (typeParameters, type, decode, annotations = {}) => ({
  _tag: "Declaration",
  typeParameters,
  type,
  decode,
  annotations
});
/**
 * @category guards
 * @since 1.0.0
 */
exports.createDeclaration = createDeclaration;
const isDeclaration = ast => ast._tag === "Declaration";
/**
 * @category constructors
 * @since 1.0.0
 */
exports.isDeclaration = isDeclaration;
const createLiteral = (literal, annotations = {}) => ({
  _tag: "Literal",
  literal,
  annotations
});
/**
 * @category guards
 * @since 1.0.0
 */
exports.createLiteral = createLiteral;
const isLiteral = ast => ast._tag === "Literal";
/** @internal */
exports.isLiteral = isLiteral;
const _null = exports._null = /*#__PURE__*/createLiteral(null);
/**
 * @category constructors
 * @since 1.0.0
 */
const createUniqueSymbol = (symbol, annotations = {}) => ({
  _tag: "UniqueSymbol",
  symbol,
  annotations
});
/**
 * @category guards
 * @since 1.0.0
 */
exports.createUniqueSymbol = createUniqueSymbol;
const isUniqueSymbol = ast => ast._tag === "UniqueSymbol";
/**
 * @category constructors
 * @since 1.0.0
 */
exports.isUniqueSymbol = isUniqueSymbol;
const undefinedKeyword = exports.undefinedKeyword = {
  _tag: "UndefinedKeyword",
  annotations: {
    [TitleAnnotationId]: "undefined"
  }
};
/**
 * @category guards
 * @since 1.0.0
 */
const isUndefinedKeyword = ast => ast._tag === "UndefinedKeyword";
/**
 * @category constructors
 * @since 1.0.0
 */
exports.isUndefinedKeyword = isUndefinedKeyword;
const voidKeyword = exports.voidKeyword = {
  _tag: "VoidKeyword",
  annotations: {
    [TitleAnnotationId]: "void"
  }
};
/**
 * @category guards
 * @since 1.0.0
 */
const isVoidKeyword = ast => ast._tag === "VoidKeyword";
/**
 * @category constructors
 * @since 1.0.0
 */
exports.isVoidKeyword = isVoidKeyword;
const neverKeyword = exports.neverKeyword = {
  _tag: "NeverKeyword",
  annotations: {
    [TitleAnnotationId]: "never"
  }
};
/**
 * @category guards
 * @since 1.0.0
 */
const isNeverKeyword = ast => ast._tag === "NeverKeyword";
/**
 * @category constructors
 * @since 1.0.0
 */
exports.isNeverKeyword = isNeverKeyword;
const unknownKeyword = exports.unknownKeyword = {
  _tag: "UnknownKeyword",
  annotations: {
    [TitleAnnotationId]: "unknown"
  }
};
/**
 * @category guards
 * @since 1.0.0
 */
const isUnknownKeyword = ast => ast._tag === "UnknownKeyword";
/**
 * @category constructors
 * @since 1.0.0
 */
exports.isUnknownKeyword = isUnknownKeyword;
const anyKeyword = exports.anyKeyword = {
  _tag: "AnyKeyword",
  annotations: {
    [TitleAnnotationId]: "any"
  }
};
/**
 * @category guards
 * @since 1.0.0
 */
const isAnyKeyword = ast => ast._tag === "AnyKeyword";
/**
 * @category constructors
 * @since 1.0.0
 */
exports.isAnyKeyword = isAnyKeyword;
const stringKeyword = exports.stringKeyword = {
  _tag: "StringKeyword",
  annotations: {
    [TitleAnnotationId]: "string",
    [DescriptionAnnotationId]: "a string"
  }
};
/**
 * @category guards
 * @since 1.0.0
 */
const isStringKeyword = ast => ast._tag === "StringKeyword";
/**
 * @category constructors
 * @since 1.0.0
 */
exports.isStringKeyword = isStringKeyword;
const numberKeyword = exports.numberKeyword = {
  _tag: "NumberKeyword",
  annotations: {
    [TitleAnnotationId]: "number",
    [DescriptionAnnotationId]: "a number"
  }
};
/**
 * @category guards
 * @since 1.0.0
 */
const isNumberKeyword = ast => ast._tag === "NumberKeyword";
/**
 * @category constructors
 * @since 1.0.0
 */
exports.isNumberKeyword = isNumberKeyword;
const booleanKeyword = exports.booleanKeyword = {
  _tag: "BooleanKeyword",
  annotations: {
    [TitleAnnotationId]: "boolean",
    [DescriptionAnnotationId]: "a boolean"
  }
};
/**
 * @category guards
 * @since 1.0.0
 */
const isBooleanKeyword = ast => ast._tag === "BooleanKeyword";
/**
 * @category constructors
 * @since 1.0.0
 */
exports.isBooleanKeyword = isBooleanKeyword;
const bigIntKeyword = exports.bigIntKeyword = {
  _tag: "BigIntKeyword",
  annotations: {
    [TitleAnnotationId]: "bigint",
    [DescriptionAnnotationId]: "a bigint"
  }
};
/**
 * @category guards
 * @since 1.0.0
 */
const isBigIntKeyword = ast => ast._tag === "BigIntKeyword";
/**
 * @category constructors
 * @since 1.0.0
 */
exports.isBigIntKeyword = isBigIntKeyword;
const symbolKeyword = exports.symbolKeyword = {
  _tag: "SymbolKeyword",
  annotations: {
    [TitleAnnotationId]: "symbol",
    [DescriptionAnnotationId]: "a symbol"
  }
};
/**
 * @category guards
 * @since 1.0.0
 */
const isSymbolKeyword = ast => ast._tag === "SymbolKeyword";
/**
 * @category constructors
 * @since 1.0.0
 */
exports.isSymbolKeyword = isSymbolKeyword;
const objectKeyword = exports.objectKeyword = {
  _tag: "ObjectKeyword",
  annotations: {
    [TitleAnnotationId]: "object",
    [DescriptionAnnotationId]: "an object"
  }
};
/**
 * @category guards
 * @since 1.0.0
 */
const isObjectKeyword = ast => ast._tag === "ObjectKeyword";
/**
 * @category constructors
 * @since 1.0.0
 */
exports.isObjectKeyword = isObjectKeyword;
const createEnums = (enums, annotations = {}) => ({
  _tag: "Enums",
  enums,
  annotations
});
/**
 * @category guards
 * @since 1.0.0
 */
exports.createEnums = createEnums;
const isEnums = ast => ast._tag === "Enums";
/**
 * @category constructors
 * @since 1.0.0
 */
exports.isEnums = isEnums;
const createTemplateLiteral = (head, spans, annotations = {}) => ReadonlyArray.isNonEmptyReadonlyArray(spans) ? {
  _tag: "TemplateLiteral",
  head,
  spans,
  annotations
} : createLiteral(head);
/**
 * @category guards
 * @since 1.0.0
 */
exports.createTemplateLiteral = createTemplateLiteral;
const isTemplateLiteral = ast => ast._tag === "TemplateLiteral";
/**
 * @since 1.0.0
 */
exports.isTemplateLiteral = isTemplateLiteral;
const createElement = (type, isOptional) => ({
  type,
  isOptional
});
/**
 * @category constructors
 * @since 1.0.0
 */
exports.createElement = createElement;
const createTuple = (elements, rest, isReadonly, annotations = {}) => ({
  _tag: "Tuple",
  elements,
  rest,
  isReadonly,
  annotations
});
/**
 * @category guards
 * @since 1.0.0
 */
exports.createTuple = createTuple;
const isTuple = ast => ast._tag === "Tuple";
/**
 * @since 1.0.0
 */
exports.isTuple = isTuple;
const createPropertySignature = (name, type, isOptional, isReadonly, annotations = {}) => ({
  name,
  type,
  isOptional,
  isReadonly,
  annotations
});
/**
 * @since 1.0.0
 */
exports.createPropertySignature = createPropertySignature;
const isParameter = ast => {
  switch (ast._tag) {
    case "StringKeyword":
    case "SymbolKeyword":
    case "TemplateLiteral":
      return true;
    case "Refinement":
      return isParameter(ast.from);
    default:
      return false;
  }
};
/**
 * @since 1.0.0
 */
exports.isParameter = isParameter;
const createIndexSignature = (parameter, type, isReadonly) => {
  if (isParameter(parameter)) {
    return {
      parameter,
      type,
      isReadonly
    };
  }
  throw new Error("An index signature parameter type must be 'string', 'symbol', a template literal type or a refinement of the previous types");
};
/**
 * @category constructors
 * @since 1.0.0
 */
exports.createIndexSignature = createIndexSignature;
const createTypeLiteral = (propertySignatures, indexSignatures, annotations = {}) => {
  // check for duplicate property signatures
  const keys = {};
  for (let i = 0; i < propertySignatures.length; i++) {
    const name = propertySignatures[i].name;
    if (Object.prototype.hasOwnProperty.call(keys, name)) {
      throw new Error(`Duplicate property signature ${String(name)}`);
    }
    keys[name] = null;
  }
  // check for duplicate index signatures
  const parameters = {
    string: false,
    symbol: false
  };
  for (let i = 0; i < indexSignatures.length; i++) {
    const parameter = getParameterBase(indexSignatures[i].parameter);
    if (isStringKeyword(parameter)) {
      if (parameters.string) {
        throw new Error("Duplicate index signature for type `string`");
      }
      parameters.string = true;
    } else if (isSymbolKeyword(parameter)) {
      if (parameters.symbol) {
        throw new Error("Duplicate index signature for type `symbol`");
      }
      parameters.symbol = true;
    }
  }
  return {
    _tag: "TypeLiteral",
    propertySignatures: sortPropertySignatures(propertySignatures),
    indexSignatures,
    annotations
  };
};
/**
 * @category guards
 * @since 1.0.0
 */
exports.createTypeLiteral = createTypeLiteral;
const isTypeLiteral = ast => ast._tag === "TypeLiteral";
exports.isTypeLiteral = isTypeLiteral;
const isMembers = as => as.length > 1;
/**
 * @category constructors
 * @since 1.0.0
 */
const createUnion = (candidates, annotations = {}) => {
  const types = unify(candidates);
  if (isMembers(types)) {
    return {
      _tag: "Union",
      types: sortUnionMembers(types),
      annotations
    };
  }
  if (ReadonlyArray.isNonEmptyReadonlyArray(types)) {
    return types[0];
  }
  return neverKeyword;
};
/**
 * @category guards
 * @since 1.0.0
 */
exports.createUnion = createUnion;
const isUnion = ast => ast._tag === "Union";
/**
 * @category constructors
 * @since 1.0.0
 */
exports.isUnion = isUnion;
const createSuspend = (f, annotations = {}) => ({
  _tag: "Suspend",
  f: Internal.memoizeThunk(f),
  annotations
});
/**
 * @category guards
 * @since 1.0.0
 */
exports.createSuspend = createSuspend;
const isSuspend = ast => ast._tag === "Suspend";
/**
 * @category constructors
 * @since 1.0.0
 */
exports.isSuspend = isSuspend;
const createRefinement = (from, filter, annotations = {}) => {
  if (isTransform(from)) {
    // recurse right
    return createTransform(from.from, createRefinement(from.to, filter, annotations), from.transformation, from.annotations);
  }
  return {
    _tag: "Refinement",
    from,
    filter,
    annotations
  };
};
/**
 * @category guards
 * @since 1.0.0
 */
exports.createRefinement = createRefinement;
const isRefinement = ast => ast._tag === "Refinement";
/**
 * @category model
 * @since 1.0.0
 */
exports.isRefinement = isRefinement;
const createTransform = (from, to, transformation, annotations = {}) => ({
  _tag: "Transform",
  from,
  to,
  transformation,
  annotations
});
/**
 * @category guards
 * @since 1.0.0
 */
exports.createTransform = createTransform;
const isTransform = ast => ast._tag === "Transform";
/**
 * @category constructors
 * @since 1.0.0
 */
exports.isTransform = isTransform;
const createFinalTransformation = (decode, encode) => ({
  _tag: "FinalTransformation",
  decode,
  encode
});
/**
 * @category guard
 * @since 1.0.0
 */
exports.createFinalTransformation = createFinalTransformation;
const isFinalTransformation = ast => ast._tag === "FinalTransformation";
/**
 * @category constructors
 * @since 1.0.0
 */
exports.isFinalTransformation = isFinalTransformation;
const composeTransformation = exports.composeTransformation = {
  _tag: "ComposeTransformation"
};
/**
 * @category guard
 * @since 1.0.0
 */
const isComposeTransformation = ast => ast._tag === "ComposeTransformation";
/**
 * @category constructors
 * @since 1.0.0
 */
exports.isComposeTransformation = isComposeTransformation;
const createFinalPropertySignatureTransformation = (decode, encode) => ({
  _tag: "FinalPropertySignatureTransformation",
  decode,
  encode
});
/**
 * @category guard
 * @since 1.0.0
 */
exports.createFinalPropertySignatureTransformation = createFinalPropertySignatureTransformation;
const isFinalPropertySignatureTransformation = ast => ast._tag === "FinalPropertySignatureTransformation";
/**
 * @category constructors
 * @since 1.0.0
 */
exports.isFinalPropertySignatureTransformation = isFinalPropertySignatureTransformation;
const createPropertySignatureTransform = (from, to, propertySignatureTransformation) => ({
  from,
  to,
  propertySignatureTransformation
});
/**
 * @category constructors
 * @since 1.0.0
 */
exports.createPropertySignatureTransform = createPropertySignatureTransform;
const createTypeLiteralTransformation = propertySignatureTransformations => {
  // check for duplicate property signature transformations
  const keys = {};
  for (const pst of propertySignatureTransformations) {
    const key = pst.from;
    if (keys[key]) {
      throw new Error(`Duplicate property signature transformation ${String(key)}`);
    }
    keys[key] = true;
  }
  return {
    _tag: "TypeLiteralTransformation",
    propertySignatureTransformations
  };
};
/**
 * @category guard
 * @since 1.0.0
 */
exports.createTypeLiteralTransformation = createTypeLiteralTransformation;
const isTypeLiteralTransformation = ast => ast._tag === "TypeLiteralTransformation";
// -------------------------------------------------------------------------------------
// API
// -------------------------------------------------------------------------------------
/**
 * Adds a group of annotations, potentially overwriting existing annotations.
 *
 * @since 1.0.0
 */
exports.isTypeLiteralTransformation = isTypeLiteralTransformation;
const mergeAnnotations = (ast, annotations) => ({
  ...ast,
  annotations: {
    ...ast.annotations,
    ...annotations
  }
});
/**
 * Adds an annotation, potentially overwriting the existing annotation with the specified id.
 *
 * @since 1.0.0
 */
exports.mergeAnnotations = mergeAnnotations;
const setAnnotation = (ast, sym, value) => ({
  ...ast,
  annotations: {
    ...ast.annotations,
    [sym]: value
  }
});
/**
 * Adds a rest element to the end of a tuple, or throws an exception if the rest element is already present.
 *
 * @since 1.0.0
 */
exports.setAnnotation = setAnnotation;
const appendRestElement = (ast, restElement) => {
  if (Option.isSome(ast.rest)) {
    // example: `type A = [...string[], ...number[]]` is illegal
    throw new Error("A rest element cannot follow another rest element. ts(1265)");
  }
  return createTuple(ast.elements, Option.some([restElement]), ast.isReadonly);
};
/**
 * Appends an element to a tuple or throws an exception in the following cases:
 * - A required element cannot follow an optional element. ts(1257)
 * - An optional element cannot follow a rest element. ts(1266)
 *
 * @since 1.0.0
 */
exports.appendRestElement = appendRestElement;
const appendElement = (ast, newElement) => {
  if (ast.elements.some(e => e.isOptional) && !newElement.isOptional) {
    throw new Error("A required element cannot follow an optional element. ts(1257)");
  }
  return (0, _Function.pipe)(ast.rest, Option.match({
    onNone: () => createTuple([...ast.elements, newElement], Option.none(), ast.isReadonly),
    onSome: rest => {
      if (newElement.isOptional) {
        throw new Error("An optional element cannot follow a rest element. ts(1266)");
      }
      return createTuple(ast.elements, Option.some([...rest, newElement.type]), ast.isReadonly);
    }
  }));
};
/**
 * Equivalent at runtime to the TypeScript type-level `keyof` operator.
 *
 * @since 1.0.0
 */
exports.appendElement = appendElement;
const keyof = ast => createUnion(_keyof(ast));
/**
 * @since 1.0.0
 */
exports.keyof = keyof;
const getPropertySignatures = ast => {
  switch (ast._tag) {
    case "TypeLiteral":
      return ast.propertySignatures;
    case "Suspend":
      return getPropertySignatures(ast.f());
  }
  throw new Error(`getPropertySignatures: unsupported schema (${ast._tag})`);
};
/**
 * Create a record with the specified key type and value type.
 *
 * @since 1.0.0
 */
exports.getPropertySignatures = getPropertySignatures;
const createRecord = (key, value, isReadonly) => {
  const propertySignatures = [];
  const indexSignatures = [];
  const go = key => {
    switch (key._tag) {
      case "NeverKeyword":
        break;
      case "StringKeyword":
      case "SymbolKeyword":
      case "TemplateLiteral":
      case "Refinement":
        indexSignatures.push(createIndexSignature(key, value, isReadonly));
        break;
      case "Literal":
        if (Predicate.isString(key.literal) || Predicate.isNumber(key.literal)) {
          propertySignatures.push(createPropertySignature(key.literal, value, false, isReadonly));
        } else {
          throw new Error(`createRecord: unsupported literal ${String(key.literal)}`);
        }
        break;
      case "UniqueSymbol":
        propertySignatures.push(createPropertySignature(key.symbol, value, false, isReadonly));
        break;
      case "Union":
        key.types.forEach(go);
        break;
      default:
        throw new Error(`createRecord: unsupported key schema (${key._tag})`);
    }
  };
  go(key);
  return createTypeLiteral(propertySignatures, indexSignatures);
};
/**
 * Equivalent at runtime to the built-in TypeScript utility type `Pick`.
 *
 * @since 1.0.0
 */
exports.createRecord = createRecord;
const pick = (ast, keys) => createTypeLiteral(getPropertySignatures(ast).filter(ps => keys.includes(ps.name)), []);
/**
 * Equivalent at runtime to the built-in TypeScript utility type `Omit`.
 *
 * @since 1.0.0
 */
exports.pick = pick;
const omit = (ast, keys) => createTypeLiteral(getPropertySignatures(ast).filter(ps => !keys.includes(ps.name)), []);
/**
 * Equivalent at runtime to the built-in TypeScript utility type `Partial`.
 *
 * @since 1.0.0
 */
exports.omit = omit;
const partial = ast => {
  switch (ast._tag) {
    case "Tuple":
      return createTuple(ast.elements.map(e => createElement(e.type, true)), (0, _Function.pipe)(ast.rest, Option.map(rest => [createUnion([...rest, undefinedKeyword])])), ast.isReadonly);
    case "TypeLiteral":
      return createTypeLiteral(ast.propertySignatures.map(f => createPropertySignature(f.name, f.type, true, f.isReadonly, f.annotations)), ast.indexSignatures);
    case "Union":
      return createUnion(ast.types.map(member => partial(member)));
    case "Suspend":
      return createSuspend(() => partial(ast.f()));
    case "Declaration":
      throw new Error("`partial` cannot handle declarations");
    case "Refinement":
      throw new Error("`partial` cannot handle refinements");
    case "Transform":
      throw new Error("`partial` cannot handle transformations");
    default:
      return ast;
  }
};
/**
 * Equivalent at runtime to the built-in TypeScript utility type `Required`.
 *
 * @since 1.0.0
 */
exports.partial = partial;
const required = ast => {
  switch (ast._tag) {
    case "Tuple":
      return createTuple(ast.elements.map(e => createElement(e.type, false)), (0, _Function.pipe)(ast.rest, Option.map(rest => {
        const u = createUnion([...rest]);
        return ReadonlyArray.map(rest, () => u);
      })), ast.isReadonly);
    case "TypeLiteral":
      return createTypeLiteral(ast.propertySignatures.map(f => createPropertySignature(f.name, f.type, false, f.isReadonly, f.annotations)), ast.indexSignatures);
    case "Union":
      return createUnion(ast.types.map(member => required(member)));
    case "Suspend":
      return createSuspend(() => required(ast.f()));
    case "Declaration":
      throw new Error("`required` cannot handle declarations");
    case "Refinement":
      throw new Error("`required` cannot handle refinements");
    case "Transform":
      throw new Error("`required` cannot handle transformations");
    default:
      return ast;
  }
};
/**
 * Creates a new AST with shallow mutability applied to its properties.
 *
 * @param ast - The original AST to make properties mutable (shallowly).
 *
 * @since 1.0.0
 */
exports.required = required;
const mutable = ast => {
  switch (ast._tag) {
    case "Tuple":
      return createTuple(ast.elements, ast.rest, false, ast.annotations);
    case "TypeLiteral":
      return createTypeLiteral(ast.propertySignatures.map(ps => createPropertySignature(ps.name, ps.type, ps.isOptional, false, ps.annotations)), ast.indexSignatures.map(is => createIndexSignature(is.parameter, is.type, false)), ast.annotations);
    case "Union":
      return createUnion(ast.types.map(mutable), ast.annotations);
    case "Suspend":
      return createSuspend(() => mutable(ast.f()), ast.annotations);
    case "Refinement":
      return createRefinement(mutable(ast.from), ast.filter, ast.annotations);
    case "Transform":
      return createTransform(mutable(ast.from), mutable(ast.to), ast.transformation, ast.annotations);
  }
  return ast;
};
/**
 * @since 1.0.0
 */
exports.mutable = mutable;
const getCompiler = match => {
  const compile = ast => match[ast._tag](ast, compile);
  return compile;
};
/** @internal */
exports.getCompiler = getCompiler;
const getToPropertySignatures = ps => ps.map(p => createPropertySignature(p.name, to(p.type), p.isOptional, p.isReadonly, p.annotations));
/** @internal */
exports.getToPropertySignatures = getToPropertySignatures;
const getToIndexSignatures = ps => ps.map(is => createIndexSignature(is.parameter, to(is.type), is.isReadonly));
/**
 * @since 1.0.0
 */
exports.getToIndexSignatures = getToIndexSignatures;
const to = ast => {
  switch (ast._tag) {
    case "Declaration":
      return createDeclaration(ast.typeParameters.map(to), to(ast.type), ast.decode, ast.annotations);
    case "Tuple":
      return createTuple(ast.elements.map(e => createElement(to(e.type), e.isOptional)), Option.map(ast.rest, ReadonlyArray.map(to)), ast.isReadonly, ast.annotations);
    case "TypeLiteral":
      return createTypeLiteral(getToPropertySignatures(ast.propertySignatures), getToIndexSignatures(ast.indexSignatures), ast.annotations);
    case "Union":
      return createUnion(ast.types.map(to), ast.annotations);
    case "Suspend":
      return createSuspend(() => to(ast.f()), ast.annotations);
    case "Refinement":
      return createRefinement(to(ast.from), ast.filter, ast.annotations);
    case "Transform":
      return to(ast.to);
  }
  return ast;
};
exports.to = to;
const preserveIdentifierAnnotation = annotated => {
  return Option.match(getIdentifierAnnotation(annotated), {
    onNone: () => undefined,
    onSome: identifier => ({
      [IdentifierAnnotationId]: identifier
    })
  });
};
/**
 * @since 1.0.0
 */
const from = ast => {
  switch (ast._tag) {
    case "Declaration":
      return createDeclaration(ast.typeParameters.map(from), from(ast.type), ast.decode, ast.annotations);
    case "Tuple":
      return createTuple(ast.elements.map(e => createElement(from(e.type), e.isOptional)), Option.map(ast.rest, ReadonlyArray.map(from)), ast.isReadonly, preserveIdentifierAnnotation(ast));
    case "TypeLiteral":
      return createTypeLiteral(ast.propertySignatures.map(p => createPropertySignature(p.name, from(p.type), p.isOptional, p.isReadonly)), ast.indexSignatures.map(is => createIndexSignature(is.parameter, from(is.type), is.isReadonly)), preserveIdentifierAnnotation(ast));
    case "Union":
      return createUnion(ast.types.map(from), preserveIdentifierAnnotation(ast));
    case "Suspend":
      return createSuspend(() => from(ast.f()), preserveIdentifierAnnotation(ast));
    case "Refinement":
    case "Transform":
      return from(ast.from);
  }
  return ast;
};
/** @internal */
exports.from = from;
const getCardinality = ast => {
  switch (ast._tag) {
    case "Declaration":
      return getCardinality(ast.type);
    case "NeverKeyword":
      return 0;
    case "Literal":
    case "UndefinedKeyword":
    case "VoidKeyword":
    case "UniqueSymbol":
      return 1;
    case "BooleanKeyword":
      return 2;
    case "StringKeyword":
    case "NumberKeyword":
    case "BigIntKeyword":
    case "SymbolKeyword":
      return 3;
    case "ObjectKeyword":
      return 5;
    case "UnknownKeyword":
    case "AnyKeyword":
      return 6;
    default:
      return 4;
  }
};
exports.getCardinality = getCardinality;
const sortPropertySignatures = /*#__PURE__*/ReadonlyArray.sort( /*#__PURE__*/(0, _Function.pipe)(Number.Order, /*#__PURE__*/Order.mapInput(ps => getCardinality(ps.type))));
const WeightOrder = /*#__PURE__*/Order.tuple(Number.Order, Number.Order, Number.Order);
const maxWeight = /*#__PURE__*/Order.max(WeightOrder);
const emptyWeight = [0, 0, 0];
const maxWeightAll = weights => weights.reduce(maxWeight, emptyWeight);
/** @internal */
const getWeight = ast => {
  switch (ast._tag) {
    case "Tuple":
      {
        const y = ast.elements.length;
        const z = Option.isSome(ast.rest) ? ast.rest.value.length : 0;
        return [2, y, z];
      }
    case "TypeLiteral":
      {
        const y = ast.propertySignatures.length;
        const z = ast.indexSignatures.length;
        return y + z === 0 ? [-4, 0, 0] : [4, y, z];
      }
    case "Declaration":
      {
        const [_, y, z] = getWeight(ast.type);
        return [6, y, z];
      }
    case "Suspend":
      return [8, 0, 0];
    case "Union":
      return maxWeightAll(ast.types.map(getWeight));
    case "Refinement":
      {
        const [x, y, z] = getWeight(ast.from);
        return [x + 1, y, z];
      }
    case "Transform":
      return getWeight(ast.from);
    case "ObjectKeyword":
      return [-2, 0, 0];
    case "UnknownKeyword":
    case "AnyKeyword":
      return [-4, 0, 0];
    default:
      return emptyWeight;
  }
};
exports.getWeight = getWeight;
const sortUnionMembers = /*#__PURE__*/ReadonlyArray.sort( /*#__PURE__*/Order.reverse( /*#__PURE__*/Order.mapInput(WeightOrder, getWeight)));
const unify = candidates => {
  let out = (0, _Function.pipe)(candidates, ReadonlyArray.flatMap(ast => {
    switch (ast._tag) {
      case "NeverKeyword":
        return [];
      case "Union":
        return ast.types;
      default:
        return [ast];
    }
  }));
  if (out.some(isAnyKeyword)) {
    return [anyKeyword];
  }
  if (out.some(isUnknownKeyword)) {
    return [unknownKeyword];
  }
  let i;
  if ((i = out.findIndex(isStringKeyword)) !== -1) {
    out = out.filter((m, j) => j === i || !isStringKeyword(m) && !(isLiteral(m) && typeof m.literal === "string"));
  }
  if ((i = out.findIndex(isNumberKeyword)) !== -1) {
    out = out.filter((m, j) => j === i || !isNumberKeyword(m) && !(isLiteral(m) && typeof m.literal === "number"));
  }
  if ((i = out.findIndex(isBooleanKeyword)) !== -1) {
    out = out.filter((m, j) => j === i || !isBooleanKeyword(m) && !(isLiteral(m) && typeof m.literal === "boolean"));
  }
  if ((i = out.findIndex(isBigIntKeyword)) !== -1) {
    out = out.filter((m, j) => j === i || !isBigIntKeyword(m) && !(isLiteral(m) && typeof m.literal === "bigint"));
  }
  if ((i = out.findIndex(isSymbolKeyword)) !== -1) {
    out = out.filter((m, j) => j === i || !isSymbolKeyword(m) && !isUniqueSymbol(m));
  }
  return out;
};
/** @internal */
const getParameterBase = ast => {
  switch (ast._tag) {
    case "StringKeyword":
    case "SymbolKeyword":
    case "TemplateLiteral":
      return ast;
    case "Refinement":
      return getParameterBase(ast.from);
  }
};
exports.getParameterBase = getParameterBase;
const _keyof = ast => {
  switch (ast._tag) {
    case "Declaration":
      return _keyof(ast.type);
    case "TypeLiteral":
      return ast.propertySignatures.map(p => Predicate.isSymbol(p.name) ? createUniqueSymbol(p.name) : createLiteral(p.name)).concat(ast.indexSignatures.map(is => getParameterBase(is.parameter)));
    case "Suspend":
      return _keyof(ast.f());
    default:
      throw new Error(`keyof: unsupported schema (${ast._tag})`);
  }
};
/** @internal */
const compose = (ab, cd) => createTransform(ab, cd, composeTransformation);
/** @internal */
exports.compose = compose;
const rename = (ast, mapping) => {
  switch (ast._tag) {
    case "TypeLiteral":
      {
        const propertySignatureTransforms = [];
        for (const key of Internal.ownKeys(mapping)) {
          const name = mapping[key];
          if (name !== undefined) {
            propertySignatureTransforms.push(createPropertySignatureTransform(key, name, createFinalPropertySignatureTransformation(_Function.identity, _Function.identity)));
          }
        }
        if (propertySignatureTransforms.length === 0) {
          return ast;
        }
        return createTransform(ast, createTypeLiteral(ast.propertySignatures.map(ps => {
          const name = mapping[ps.name];
          return createPropertySignature(name === undefined ? ps.name : name, to(ps.type), ps.isOptional, ps.isReadonly, ps.annotations);
        }), ast.indexSignatures), createTypeLiteralTransformation(propertySignatureTransforms));
      }
    case "Suspend":
      return createSuspend(() => rename(ast.f(), mapping));
    case "Transform":
      return compose(ast, rename(to(ast), mapping));
  }
  throw new Error(`cannot rename ${ast._tag}`);
};
exports.rename = rename;
//# sourceMappingURL=AST.js.map