import type { Component } from 'vue';
import type { ExternalToast, ToastT, PromiseData, PromiseT, ToastToDismiss, ToastTypes } from './types';
declare class Observer {
    subscribers: Array<(toast: ExternalToast | ToastToDismiss) => void>;
    toasts: Array<ToastT | ToastToDismiss>;
    constructor();
    subscribe: (subscriber: (toast: ToastT | ToastToDismiss) => void) => () => void;
    publish: (data: ToastT) => void;
    addToast: (data: ToastT) => void;
    create: (data: ExternalToast & {
        message?: string | Component;
        type?: ToastTypes;
        promise?: PromiseT;
    }) => string | number;
    dismiss: (id?: number | string) => string | number | undefined;
    message: (message: string | Component, data?: ExternalToast) => string | number;
    error: (message: string | Component, data?: ExternalToast) => string | number;
    success: (message: string | Component, data?: ExternalToast) => string | number;
    info: (message: string | Component, data?: ExternalToast) => string | number;
    warning: (message: string | Component, data?: ExternalToast) => string | number;
    loading: (message: string | Component, data?: ExternalToast) => string | number;
    promise: <ToastData>(promise: PromiseT<ToastData>, data?: PromiseData<ToastData> | undefined) => string | number | undefined;
    custom: (component: Component, data?: ExternalToast) => string | number;
}
export declare const ToastState: Observer;
export declare const toast: ((message: string | Component, data?: ExternalToast) => string | number) & {
    success: (message: string | Component, data?: ExternalToast) => string | number;
    info: (message: string | Component, data?: ExternalToast) => string | number;
    warning: (message: string | Component, data?: ExternalToast) => string | number;
    error: (message: string | Component, data?: ExternalToast) => string | number;
    custom: (component: Component, data?: ExternalToast) => string | number;
    message: (message: string | Component, data?: ExternalToast) => string | number;
    promise: <ToastData>(promise: PromiseT<ToastData>, data?: PromiseData<ToastData> | undefined) => string | number | undefined;
    dismiss: (id?: number | string) => string | number | undefined;
    loading: (message: string | Component, data?: ExternalToast) => string | number;
};
export {};
