import { pathToFileURL } from 'node:url';
import { workerId } from 'tinypool';
import { ViteNodeRunner, ModuleCacheMap } from 'vite-node/client';
import { resolve, normalize } from 'pathe';
import { e as environments } from './vendor/index.GVFv9dZ0.js';
import { i as isChildProcess, s as setProcessTitle } from './vendor/base.N3JkKp7j.js';
import { createRequire } from 'node:module';
import { c as createRuntimeRpc, a as rpcDone } from './vendor/rpc.joBhAkyK.js';
import 'node:console';
import '@vitest/utils';
import './vendor/index.8bPxjt7g.js';
import './vendor/global.CkGT_TMy.js';

function isBuiltinEnvironment(env) {
  return env in environments;
}
const _loaders = /* @__PURE__ */ new Map();
async function createEnvironmentLoader(options) {
  if (!_loaders.has(options.root)) {
    const loader = new ViteNodeRunner(options);
    await loader.executeId("/@vite/env");
    _loaders.set(options.root, loader);
  }
  return _loaders.get(options.root);
}
async function loadEnvironment(ctx, rpc) {
  var _a;
  const name = ctx.environment.name;
  if (isBuiltinEnvironment(name))
    return environments[name];
  const loader = await createEnvironmentLoader({
    root: ctx.config.root,
    fetchModule: (id) => rpc.fetch(id, "ssr"),
    resolveId: (id, importer) => rpc.resolveId(id, importer, "ssr")
  });
  const root = loader.root;
  const packageId = name[0] === "." || name[0] === "/" ? resolve(root, name) : ((_a = await rpc.resolveId(`vitest-environment-${name}`, void 0, "ssr")) == null ? void 0 : _a.id) ?? resolve(root, name);
  const pkg = await loader.executeId(normalize(packageId));
  if (!pkg || !pkg.default || typeof pkg.default !== "object") {
    throw new TypeError(
      `Environment "${name}" is not a valid environment. Path "${packageId}" should export default object with a "setup" or/and "setupVM" method.`
    );
  }
  const environment = pkg.default;
  if (environment.transformMode !== "web" && environment.transformMode !== "ssr") {
    throw new TypeError(
      `Environment "${name}" is not a valid environment. Path "${packageId}" should export default object with a "transformMode" method equal to "ssr" or "web".`
    );
  }
  return environment;
}

const __require = createRequire(import.meta.url);
let inspector;
function setupInspect(config) {
  var _a, _b, _c, _d, _e, _f, _g, _h;
  const isEnabled = config.inspect || config.inspectBrk;
  if (isEnabled) {
    inspector = __require("node:inspector");
    const isOpen = inspector.url() !== void 0;
    if (!isOpen) {
      inspector.open();
      if (config.inspectBrk)
        inspector.waitForDebugger();
    }
  }
  const isIsolatedSingleThread = config.pool === "threads" && ((_b = (_a = config.poolOptions) == null ? void 0 : _a.threads) == null ? void 0 : _b.isolate) === false && ((_d = (_c = config.poolOptions) == null ? void 0 : _c.threads) == null ? void 0 : _d.singleThread);
  const isIsolatedSingleFork = config.pool === "forks" && ((_f = (_e = config.poolOptions) == null ? void 0 : _e.forks) == null ? void 0 : _f.isolate) === false && ((_h = (_g = config.poolOptions) == null ? void 0 : _g.forks) == null ? void 0 : _h.singleFork);
  const keepOpen = config.watch && (isIsolatedSingleFork || isIsolatedSingleThread);
  return function cleanup() {
    if (isEnabled && !keepOpen && inspector)
      inspector.close();
  };
}

if (isChildProcess())
  setProcessTitle(`vitest ${workerId}`);
async function run(ctx) {
  const prepareStart = performance.now();
  const inspectorCleanup = setupInspect(ctx.config);
  process.env.VITEST_WORKER_ID = String(ctx.workerId);
  process.env.VITEST_POOL_ID = String(workerId);
  try {
    if (ctx.worker[0] === ".")
      throw new Error(`Path to the test runner cannot be relative, received "${ctx.worker}"`);
    const file = ctx.worker.startsWith("file:") ? ctx.worker : pathToFileURL(ctx.worker).toString();
    const testRunnerModule = await import(file);
    if (!testRunnerModule.default || typeof testRunnerModule.default !== "object")
      throw new TypeError(`Test worker object should be exposed as a default export. Received "${typeof testRunnerModule.default}"`);
    const worker = testRunnerModule.default;
    if (!worker.getRpcOptions || typeof worker.getRpcOptions !== "function")
      throw new TypeError(`Test worker should expose "getRpcOptions" method. Received "${typeof worker.getRpcOptions}".`);
    const { rpc, onCancel } = createRuntimeRpc(worker.getRpcOptions(ctx));
    const beforeEnvironmentTime = performance.now();
    const environment = await loadEnvironment(ctx, rpc);
    if (ctx.environment.transformMode)
      environment.transformMode = ctx.environment.transformMode;
    const state = {
      ctx,
      // here we create a new one, workers can reassign this if they need to keep it non-isolated
      moduleCache: new ModuleCacheMap(),
      mockMap: /* @__PURE__ */ new Map(),
      config: ctx.config,
      onCancel,
      environment,
      durations: {
        environment: beforeEnvironmentTime,
        prepare: prepareStart
      },
      rpc,
      providedContext: ctx.providedContext
    };
    if (!worker.runTests || typeof worker.runTests !== "function")
      throw new TypeError(`Test worker should expose "runTests" method. Received "${typeof worker.runTests}".`);
    await worker.runTests(state);
  } finally {
    await rpcDone().catch(() => {
    });
    inspectorCleanup();
  }
}

export { run };
