# Change Log

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](http://keepachangelog.com/) and this
project adheres to [Semantic Versioning](http://semver.org/).

## [Unreleased](https://github.com/dividab/tsconfig-paths-webpack-plugin/compare/v4.1.0...master)

## [4.1.0](https://github.com/dividab/tsconfig-paths-webpack-plugin/compare/v4.0.1...v4.1.0) - 2023-07-11

### Added

- Remove warning on missing baseUrl, which tsconfig-paths ^4.0.0 doesn't require anymore [#105](https://github.com/dividab/tsconfig-paths-webpack-plugin/pull/105). Thanks to [@sverweij](https://github.com/sverweij) for this PR!

- Add support for multiple tsconfig paths [#79](https://github.com/dividab/tsconfig-paths-webpack-plugin/pull/79). Thanks to [@lynch16](https://github.com/lynch16) for this PR!

### Fixed

- Update tsconfig file name in .npmignore [#100](https://github.com/dividab/tsconfig-paths-webpack-plugin/pull/100). Thanks to [@tcd](https://github.com/tcd) for this PR!


## [4.0.1](https://github.com/dividab/tsconfig-paths-webpack-plugin/compare/v4.0.0...v4.0.1) - 2023-03-09

- Update tsconfig-paths [#103](https://github.com/dividab/tsconfig-paths-webpack-plugin/pull/103). Thanks to [@rippedspine](https://github.com/rippedspine) for this PR!

## [4.0.0](https://github.com/dividab/tsconfig-paths-webpack-plugin/compare/v3.5.2...v4.0.0) - 2022-07-29

- chore: update tsconfig-paths dependency [#90](https://github.com/dividab/tsconfig-paths-webpack-plugin/pull/90). Thanks to [@MichaelDeBoey](https://github.com/MichaelDeBoey) for this PR!

- Update webpack and remove temp types [#92](https://github.com/dividab/tsconfig-paths-webpack-plugin/pull/92). Thanks to [@hungtcs](https://github.com/hungtcs) for this PR!

- Eslint (#95)

- Upgrade ci and jest (#96)

## [3.5.2](https://github.com/dividab/tsconfig-paths-webpack-plugin/compare/v3.5.1...v3.5.2) - 2021-11-13

### Fixed

- Fix incorrect resolution with relative imports on project dependencies [#85](https://github.com/dividab/tsconfig-paths-webpack-plugin/pull/85). Thanks to [@voliva](https://github.com/voliva) for this fix!

- Remove `console.log` from `plugin.ts` [#72](https://github.com/dividab/tsconfig-paths-webpack-plugin/pull/72). Thanks to [@visualfanatic](https://github.com/visualfanatic) for this fix!

## [3.5.1](https://github.com/dividab/tsconfig-paths-webpack-plugin/compare/v3.5.0...v3.5.1) - 2021-03-16

### Fixed

- Remove `console.log` from `plugin.ts` [#72](https://github.com/dividab/tsconfig-paths-webpack-plugin/pull/72). Thanks to [@visualfanatic](https://github.com/visualfanatic) for this fix!

## [3.5.0](https://github.com/dividab/tsconfig-paths-webpack-plugin/compare/v3.4.1...v3.5.0) - 2021-03-15

### Added

- Copied webpack 5 types into `plugins.temp.types.ts` [#51](https://github.com/dividab/tsconfig-paths-webpack-plugin/pull/70). Thanks to [@Brian-McBride](https://github.com/Brian-McBride) for this addition!

## [3.4.1](https://github.com/dividab/tsconfig-paths-webpack-plugin/compare/v3.4.0...v3.4.1) - 2021-03-13

### Fixed

- Use prepare instead of postinstall for husky.

## [3.4.0](https://github.com/dividab/tsconfig-paths-webpack-plugin/compare/v3.3.0...v3.4.0) - 2021-03-13

### Added

- Support for Webpack 5, see [#51](https://github.com/dividab/tsconfig-paths-webpack-plugin/pull/66). Fixes [#50](https://github.com/dividab/tsconfig-paths-webpack-plugin/issues/61). Thanks to [@Brian-McBride](https://github.com/Brian-McBride) for this addition!

## [3.3.0](https://github.com/dividab/tsconfig-paths-webpack-plugin/compare/3.2.0...v3.3.0) - 2020-07-29

### Added

- Add readJson fallback to support custom file systems, see [#51](https://github.com/dividab/tsconfig-paths-webpack-plugin/pull/51). Fixes [#50](https://github.com/dividab/tsconfig-paths-webpack-plugin/issues/50). Thanks to [@JakeSidSmith](https://github.com/JakeSidSmith) for this addition!

## [3.2.0](https://github.com/dividab/tsconfig-paths-webpack-plugin/compare/3.1.4...3.2.0) - 2018-06-12

### Added

- Add `mainFields` option [#21](https://github.com/dividab/tsconfig-paths-webpack-plugin/pull/21), fixes [#20](https://github.com/dividab/tsconfig-paths-webpack-plugin/issues/20). Thanks to [@christoffer](https://github.com/christoffer) for this addition!

## [3.1.4](https://github.com/dividab/tsconfig-paths-webpack-plugin/compare/3.1.3...3.1.4) - 2018-06-04

### Fixed

- Add undeclared dependency on `enhanced-resolve` to `dependencies`, see #19. Thanks to [@jbboehr](https://github.com/jbboehr) for this fix!

## [3.1.3](https://github.com/dividab/tsconfig-paths-webpack-plugin/compare/3.1.2...3.1.3) - 2018-05-14

### Fixed

- Fix exports so all types of imports works (commonjs require and typescript import).

## [3.1.2](https://github.com/dividab/tsconfig-paths-webpack-plugin/compare/3.1.1...3.1.2) - 2018-05-14

### Fixed

- Add types field to package.json.

## [3.1.1](https://github.com/dividab/tsconfig-paths-webpack-plugin/compare/3.1.0...3.1.1) - 2018-05-14

### Fixed

- Add named typescript export.

## [3.1.0](https://github.com/dividab/tsconfig-paths-webpack-plugin/compare/3.0.4...3.1.0) - 2018-05-14

### Added

- Typescript typings, see [#16](https://github.com/dividab/tsconfig-paths/issues/16).

## [3.0.4](https://github.com/dividab/tsconfig-paths-webpack-plugin/compare/3.0.4...3.0.4) - 2018-04-17

### Fixed

- Add missing module dependency [#15](https://github.com/dividab/tsconfig-paths/pull/15). Thanks to [@darlanalves](https://github.com/darlanalves) for this fix!

## [3.0.3](https://github.com/dividab/tsconfig-paths-webpack-plugin/compare/3.0.2...3.0.3) - 2018-03-31

### Fixed

- Fix configFileName not working as expected, see https://github.com/dividab/tsconfig-paths/issues/31.
- Upgraded tsconfig-paths to 3.2.0 which includes the fix in https://github.com/dividab/tsconfig-paths/pull/32.

## [3.0.2](https://github.com/dividab/tsconfig-paths-webpack-plugin/compare/3.0.1...3.0.2) - 2018-03-14

### Fixed

- Upgraded tsconfig-paths to 3.1.3 which includes the fix in https://github.com/dividab/tsconfig-paths/pull/30.

## [3.0.1](https://github.com/dividab/tsconfig-paths-webpack-plugin/compare/3.0.0...3.0.1) - 2018-03-13

### Fixed

- Upgraded tsconfig-paths to 3.1.2 which includes the fix in https://github.com/dividab/tsconfig-paths/pull/29.

- Fix for the new webpack 4 code to prevent callback from firing multiple times, see [#11](https://github.com/dividab/tsconfig-paths-webpack-plugin/issues/11). Thanks to [@Nayni](https://github.com/Nayni) for this fix! (See PR [#12](https://github.com/dividab/tsconfig-paths-webpack-plugin/pull/12)).

## [3.0.0](https://github.com/dividab/tsconfig-paths-webpack-plugin/compare/2.0.0...3.0.0) - 2018-03-13

### Added

- Proper support for webpack 4. See [#9](https://github.com/dividab/tsconfig-paths-webpack-plugin/issues/9). Thanks to [@Nayni](https://github.com/Nayni) for adding this! (See PR [#10](https://github.com/dividab/tsconfig-paths-webpack-plugin/pull/10))

## [2.0.0](https://github.com/dividab/tsconfig-paths-webpack-plugin/compare/1.4.0...2.0.0) - 2018-01-13

### Changed

- Performance enhancements:
  - Using async versions of tsconfig-paths package matchPath functions.
  - Using webpack's cached filesystem. Should give better performance.

## [1.4.0](https://github.com/dividab/tsconfig-paths-webpack-plugin/compare/1.3.1...1.4.0)

### Changed

- Only log startup message when `logLevel` is set to `info`. See [#6](https://github.com/dividab/tsconfig-paths-webpack-plugin/issues/6).

## [1.3.1](https://github.com/dividab/tsconfig-paths-webpack-plugin/compare/1.3.0...1.3.1)

### Added

- Upgraded to tsconfig-paths 2.7.2.

## [1.3.0](https://github.com/dividab/tsconfig-paths-webpack-plugin/compare/1.2.0...1.3.0)

### Added

- Upgraded to tsconfig-paths 2.7.1.

## [1.2.0](https://github.com/dividab/tsconfig-paths-webpack-plugin/compare/1.1.0...1.2.0)

### Added

- Added option for `baseUrl`.

## [1.1.0](https://github.com/dividab/tsconfig-paths-webpack-plugin/compare/1.0.0...1.1.0)

### Added

- Added option for `extensions`.

## [1.0.0](https://github.com/dividab/tsconfig-paths-webpack-plugin/compare/0.4.0...1.0.0)

### Changed

- Log path to tsconfig.json at warn log level so it is logged as default.

## [0.4.0](https://github.com/dividab/tsconfig-paths-webpack-plugin/compare/0.3.0...0.4.0)

### Changed

- Rename plugin class to TsconfigPathsPlugin (lower case s, breaking change)
- Load config using tsconfig-paths.

### Removed

- Remove compiler option (it was not used)

## [0.3.0](https://github.com/dividab/tsconfig-paths-webpack-plugin/compare/0.2.0...0.3.0)

### Changed

- Use package tsconfig-paths to resolve paths.

## [0.2.0](https://github.com/dividab/tsconfig-paths-webpack-plugin/compare/0.1.1...0.2.0)

### Changed

- Internal refactor

## [0.1.1](https://github.com/dividab/tsconfig-paths-webpack-plugin/compare/0.1.0...0.1.1)

### Added

- Include files.

## 0.1.0

### Added

- First release.
