import { Ok } from '.';
import { isOk } from './is-ok';
/**
 * Takes an array of `Result` values and returns a `Result` containing an array of `Ok` values if all the input values
 * are `Ok`. If any input value is an `Err`, returns the first encountered `Err`.
 *
 * @tags result, array
 */
export function sequence(results) {
    const okValues = [];
    for (const result of results) {
        if (isOk(result)) {
            okValues.push(result.value);
        }
        else {
            return result;
        }
    }
    return new Ok(okValues);
}
