import { none, Some } from '../option';
import { isOk } from './is-ok';
/**
 * Transforms `Result<T, E>` into `Option<T>`, mapping `Ok(v)` to `Some(v)` and `Err(e)` to `None`.
 *
 * @tags result, option, transform, transform-result
 */
export function ok(res) {
    return isOk(res) ? new Some(res.value) : none;
}
