import { curry } from '../fn/curry';
import { isOk } from './is-ok';
import { withCatch } from './lib/with-catch';
/**
 * Returns the provided default (if `Err`), or applies a function to the contained value (if `Ok`),
 *
 * Arguments passed to `mapOr` are eagerly evaluated; if you are passing the result of a function call, it is
 * recommended to use `mapOrElse`, which is lazily evaluated.
 *
 * @tags result, transform, transform-result, right-biased, unwrap
 */
export const mapOr = curry(withCatch((defaultValue, mapOkFn, result) => {
    return isOk(result) ? mapOkFn(result.value) : defaultValue;
}), 3);
