import { curry } from '../fn/curry';
import { isOk } from './is-ok';
import { withCatch } from './lib/with-catch';
/**
 * Maps a `Result` by applying fallback function default to a contained `Err` value, or a function to a contained `Ok`
 * value.
 *
 * This function can be used to unpack a successful result while handling an error.
 *
 * @tags result, transform, transform-result, right-biased, unwrap
 */
export const mapOrElse = curry(withCatch((mapErrFn, mapOkFn, result) => {
    return isOk(result)
        ? mapOkFn(result.value)
        : mapErrFn(result.value);
}), 3);
