import { curry } from '../fn/curry';
import { Err, Ok } from '../result';
/**
 * Divide one number by another.
 *
 * @tags numbers, transform, transform-value
 */
export const divide = curry((divisor, value) => {
    if (divisor === 0) {
        return new Err(new Error('Cannot divide by zero'));
    }
    return new Ok(value / divisor);
}, 2);
