import { curry } from '../fn/curry';
import { hasType } from './has-type';
import { isFunction } from './is-function';
/**
 * Asserts that a value is a `Function` which throws an `Error` of the given type.
 *
 * @tags guard, functions, errors
 */
export const throwsErrorOfType = curry((typeName, value) => {
    try {
        if (!isFunction(value))
            return false;
        value();
        return false;
    }
    catch (err) {
        return hasType(typeName, err);
    }
}, 2);
