import { isFunction } from './is-function';
/**
 * Asserts that a value is a `Function` which throws when invoked.
 *
 * @tags guard, functions, errors
 */
export const throwsAnyError = (value) => {
    try {
        if (!isFunction(value))
            return false;
        value();
        return false;
    }
    catch (err) {
        return true;
    }
};
