import { isObject } from './is-object';
/**
 * Asserts that a value is an `Object` containing at least one own member.
 *
 * @tags guard, objects, emptiness
 */
export function isNonEmptyObject(value) {
    return isObject(value) && Object.keys(value).length > 0;
}
