import { isString } from './is-string';
import { isValidDate } from './is-valid-date';
/**
 * Asserts that a value is a String which conforms to common use-cases of the ISO 8601 standard representation of dates
 * and times.
 *
 * @tags guard, strings, dates
 */
export const isIso8601 = (value) => {
    // '1999-12-31'
    // '1999-12-31T23:59'
    // '1999-12-31T23:59:59'
    // '1999-12-31T23:59:59.000'
    // '1999-12-31T23:59:59.000Z'
    // '1999-12-31T23:59:59+01:00'
    // '1999-12-31T23:59:59-01:00'
    // '1999-12-31T23:59:59.000+01:00'
    // '1999-12-31T23:59:59.000-01:00'
    return (isString(value) &&
        (/^([0-9]{4})-([0-9]{2})-([0-9]{2})$/.test(value) ||
            /^([0-9]{4})-([0-9]{2})-([0-9]{2})T([0-9]{2}):([0-9]{2})$/.test(value) ||
            /^([0-9]{4})-([0-9]{2})-([0-9]{2})T([0-9]{2}):([0-9]{2}):([0-9]{2})$/.test(value) ||
            /^([0-9]{4})-([0-9]{2})-([0-9]{2})T([0-9]{2}):([0-9]{2}):([0-9]{2})\.([0-9]{3})$/.test(value) ||
            /^([0-9]{4})-([0-9]{2})-([0-9]{2})T([0-9]{2}):([0-9]{2}):([0-9]{2})\.([0-9]{3})Z$/.test(value) ||
            /^([0-9]{4})-([0-9]{2})-([0-9]{2})T([0-9]{2}):([0-9]{2}):([0-9]{2})([+-][0-9]{2}:[0-9]{2})$/.test(value) ||
            /^([0-9]{4})-([0-9]{2})-([0-9]{2})T([0-9]{2}):([0-9]{2}):([0-9]{2})\.([0-9]{3})([+-][0-9]{2}:[0-9]{2})$/.test(value)) &&
        isValidDate(new Date(value)));
};
