import { curry } from '../fn/curry';
import { isNumber } from './is-number';
/**
 * Asserts that a value is greater than or equal to other.
 *
 * @tags guard, numbers, comparator
 */
export const isGreaterThanOrEqualTo = curry((other, value) => isNumber(value) && isNumber(other) && value >= other, 2);
