import { curry } from '../fn/curry';
import { isNumber } from './is-number';
/**
 * Asserts that a value is a `Number` which results in a whole number when divided by another.
 *
 * @tags guard, numbers
 */
export const isDivisibleBy = curry((other, value) => isNumber(value) && isNumber(other) && value % other === 0, 2);
