import { curry } from '../fn/curry';
import { isDate } from './is-date';
import { isNumber } from './is-number';
/**
 * Asserts that a value is an instance of `Date` occurring on the day of the week with the given index, where Sunday is
 * `0` and Saturday is `6`.
 *
 * @tags guard, dates, comparator
 */
export const isDateOnDayOfWeek = curry((index, value) => isDate(value) && isNumber(index) && value.getDay() === index, 2);
