import { curry } from '../fn/curry';
import { isDate } from './is-date';
import { isNumber } from './is-number';
/**
 * Asserts that a value is an instance of `Date` occurring in the given year.
 *
 * @tags guard, dates, comparator
 */
export const isDateInYear = curry((year, value) => isDate(value) && isNumber(year) && value.getFullYear() === year, 2);
