import { curry } from '../fn/curry';
import { isAfter } from './is-after';
/**
 * Asserts that a value is a valid instance of `Date` whose value occurs before that of another.
 *
 * @tags guard, dates, comparator
 */
export const isBefore = curry((other, value) => isAfter(value, other), 2);
