import { curry } from '../fn/curry';
import { isNonEmptyArray } from './is-non-empty-array';
/**
 * Does every value pass the given Guard?
 *
 * ## Examples
 *
 * ```ts
 * isArrayOf(isNonEmptyString, ['click', 'mousedown', 'load']);
 * ```
 *
 * @tags guard, arrays
 */
export const isArrayOf = curry((guard, values) => isNonEmptyArray(values) && values.every((value) => guard(value)), 2);
