type IsArrayIncludingAnyOf = {
    (allowedValues: unknown[]): {
        (value: unknown): boolean;
    };
    (allowedValues: unknown[], value: unknown): boolean;
};
/**
 * Asserts that `value` is an `Array` including at least one of the members of `allowedValues`.
 *
 * @tags guard, arrays, multiple-conditions
 */
export declare const isArrayIncludingAnyOf: IsArrayIncludingAnyOf;
export {};
