/**
 * Consume a generator and `yield` only the final result.
 *
 * @tags generator
 */
export function* takeLast(gen) {
    let didYield = false;
    let last = null;
    for (const value of gen) {
        didYield = true;
        last = value;
    }
    if (didYield) {
        yield last;
    }
}
