export function curry(fn, arity = fn.length) {
    return function curriedFn(...args) {
        if (args.length >= arity) {
            return fn(...args);
        }
        return curriedFn.bind(null, ...args);
    };
}
