"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.option = void 0;
const chalk_1 = __importDefault(require("chalk"));
const constants_1 = require("./constants");
exports.option = {
    config: ['-c, --config <path>', 'path to a syncpack config file'],
    filter: [
        '-f, --filter [pattern]',
        (0, chalk_1.default) `only include dependencies whose {yellow name} matches this regex`,
    ],
    indent: ['-i, --indent [value]', `override indentation. defaults to "${constants_1.DEFAULT_CONFIG.indent}"`],
    source: [
        '-s, --source [pattern]',
        'glob pattern for package.json files to read from',
        collect,
        [],
    ],
    specs: [
        '-s, --specs <names>',
        (0, chalk_1.default) `only include dependencies whose version specifier match these types (eg. {yellow specs=latest,range,workspace-protocol})`,
    ],
    types: [
        '-t, --types <names>',
        (0, chalk_1.default) `only include dependencies matching these types (eg. {yellow types=dev,prod,myCustomType})`,
    ],
};
function collect(value, previous) {
    return previous.concat([value]);
}
