"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DEFAULT_CONFIG = exports.CUSTOM_TYPES = exports.INTERNAL_TYPES = exports.RANGE = exports.ICON = exports.CWD = void 0;
/** Single source of truth, intended to aid testing or to override */
exports.CWD = process.env.MOCK_CWD || process.cwd();
/** Single source of truth for icons used in output */
exports.ICON = {
    banned: '⦸',
    cross: '✘',
    debug: '?',
    info: 'i',
    panic: '!',
    rightArrow: '→',
    skip: '-',
    tick: '✓',
};
exports.RANGE = {
    ANY: '*',
    EXACT: '',
    GT: '>',
    GTE: '>=',
    LOOSE: '.x',
    LT: '<',
    LTE: '<=',
    MINOR: '^',
    PATCH: '~',
    WORKSPACE: 'workspace:',
};
exports.INTERNAL_TYPES = [
    'dev',
    'local',
    'overrides',
    'peer',
    'pnpmOverrides',
    'prod',
    'resolutions',
];
exports.CUSTOM_TYPES = {
    dev: {
        strategy: 'versionsByName',
        path: 'devDependencies',
    },
    local: {
        strategy: 'name~version',
        namePath: 'name',
        path: 'version',
    },
    overrides: {
        strategy: 'versionsByName',
        path: 'overrides',
    },
    peer: {
        strategy: 'versionsByName',
        path: 'peerDependencies',
    },
    pnpmOverrides: {
        strategy: 'versionsByName',
        path: 'pnpm.overrides',
    },
    prod: {
        strategy: 'versionsByName',
        path: 'dependencies',
    },
    resolutions: {
        strategy: 'versionsByName',
        path: 'resolutions',
    },
};
exports.DEFAULT_CONFIG = {
    customTypes: exports.CUSTOM_TYPES,
    dependencyTypes: ['**'],
    filter: '.',
    formatBugs: true,
    formatRepository: true,
    indent: '  ',
    lintFormatting: true,
    lintSemverRanges: true,
    lintVersions: true,
    semverGroups: [],
    sortAz: [
        'bin',
        'contributors',
        'dependencies',
        'devDependencies',
        'keywords',
        'peerDependencies',
        'resolutions',
        'scripts',
    ],
    sortExports: [
        'types',
        'node-addons',
        'node',
        'browser',
        'import',
        'require',
        'development',
        'production',
        'default',
    ],
    sortFirst: ['name', 'description', 'version', 'author'],
    sortPackages: true,
    source: ['package.json', 'packages/*/package.json'],
    specifierTypes: ['**'],
    versionGroups: [],
};
