# plugins [![NPM version](https://badge.fury.io/js/plugins.svg)](http://badge.fury.io/js/plugins)

> Run a value through a plugin stack.

## Install

Install with [npm](https://www.npmjs.com/)

```sh
$ npm i plugins --save
```

See [the examples](examples/).

## Table of contents

<!-- toc -->

* [Docs](#docs)
* [Creating plugins](#creating-plugins)
  - [sync](#sync)
  - [async](#async)
  - [Directly run plugins](#directly-run-plugins)
* [API](#api)
* [Related projects](#related-projects)
* [Running tests](#running-tests)
* [Contributing](#contributing)
* [Author](#author)
* [License](#license)

_(Table of contents generated by [verb])_

<!-- tocstop -->

## Docs

See [the examples](examples/).

## Creating plugins

> A plugin can take any arguments and **must return a function**.

### sync

Plugins just return a value.

**Example:**

```js
var plugins = new Plugins();

plugins
  .use(function (str) {
    return str + 'a';
  })
  .use(function (str) {
    return str + 'b';
  })
  .use(function (str) {
    return str + 'c';
  });

console.log(plugins.run('alphabet-'));
//=> 'alphabet-abc'
```

### async

Pass `next` as the last argument to run plugins asynchronously.

**Example:**

```js
var plugins = new Plugins();

plugins
  .use(function (str, next) {
    next(null, str + 'a');
  })
  .use(function (str, next) {
    next(null, str + 'b');
  })
  .use(function (str, next) {
    next(null, str + 'c');
  });

plugins.run('alphabet-', function (err, str) {
  console.log(str); //=> 'alphabet-abc'
});
```

### Directly run plugins

To run plugins **without** `.use()`, pass an array of functions as a section argument to `.run()`.

**sync example:**

```js
var plugins = new Plugins();

var a = function(val) {
  return val + 'a';
};
var b = function(val) {
  return val + 'b';
};
var c = function(val) {
  return val + 'c';
};

console.log(plugins.run('alphabet-', [a, b, c]));
//=> 'alphabet-abc'
```

**async example:**

```js
var plugins = new Plugins();

var a = function (str, next) {
  next(null, str + 'a');
};
var b = function (str, next) {
  next(null, str + 'b');
};
var c = function (str, next) {
  next(null, str + 'c');
};

plugins.run('alphabet-', [a, b, c], function (err, str) {
  console.log(str); //=> 'alphabet-abc'
});
```

## API

See [the examples](examples/).

### [Plugins](index.js#L23)

Initialize `Plugins`

**Example**

```js
var Plugins = require('plugins');
var plugins = new Plugins();
```

### [.use](index.js#L57)

Add a plugin `fn` to the `plugins` stack.

**Params**

* `fn` **{Function}**: Plugin function to add to the `plugins` stack.
* `returns` **{Object}** `Plugins`: to enable chaining.

**Example**

```js
plugins
  .use(foo)
  .use(bar)
  .use(baz)
```

### [.run](index.js#L73)

Call each `fn` in the `plugins` stack to iterate over `val`.

**Params**

* `val` **{Array|Object|String}**: The value to iterate over.

**Example**

```js
plugins.run(value)
```

### [.iterator](index.js#L87)

Register an iterator `fn` by its `type`.

**Params**

* `type` **{String}**: The iterator type.
* `fn` **{Function}**: Iterator function

### [.pipeline](index.js#L103)

Add each plugin to a pipeline to be used with streams. Plugins must either be a stream or a function that returns a stream.

**Params**

* `val` **{Array|Object|String}**: The value to iterate over.

**Example**

```js
var pipeline = plugins.pipeline(plugin());
```

## Related projects

[async-array-reduce](https://github.com/jonschlinkert/async-array-reduce): Async reduce.

## Running tests

Install dev dependencies:

```sh
$ npm i -d && npm test
```

## Contributing

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](https://github.com/jonschlinkert/plugins/issues/new)

## Author

**Jon Schlinkert**

+ [github/jonschlinkert](https://github.com/jonschlinkert)
+ [twitter/jonschlinkert](http://twitter.com/jonschlinkert)

## License

Copyright © 2015 Jon Schlinkert
Released under the MIT license.

***

_This file was generated by [verb-cli](https://github.com/assemble/verb-cli) on August 14, 2015._

[verb]: https://github.com/assemble/verb