const remPx = {
  '0rem': '0px',
  '0.0625rem': '1px',
  '0.125rem': '2px',
  '0.1875rem': '3px',
  '0.25rem': '4px',
  '0.3125rem': '5px',
  '0.375rem': '6px',
  '0.4375rem': '7px',
  '0.5rem': '8px',
  '0.5625rem': '9px',
  '0.625rem': '10px',
  '0.6875rem': '11px',
  '.75rem': '12px',
  '0.75rem': '12px',
  '0.8125rem': '13px',
  '0.875rem': '14px',
  '0.9375rem': '15px',
  '1rem': '16px',
  '1.0625rem': '17px',
  '1.125rem': '18px',
  '1.1875rem': '19px',
  '1.25rem': '20px',
  '1.3125rem': '21px',
  '1.375rem': '22px',
  '1.4375rem': '23px',
  '1.5rem': '24px',
  '1.625rem': '26px',
  '1.75rem': '28px',
  '1.875rem': '30px',
  '2rem': '32px',
  '2.25rem': '36px',
  '2.5rem': '40px',
  '2.75rem': '44px',
  '3rem': '48px',
  '3.5rem': '56px',
  '3.75rem': '60px',
  '4rem': '64px',
  '4.5rem': '72px',
  '5rem': '80px',
  '5.125rem': '82px',
  '5.25': '84px',
  '5.375rem': '86px',
  '5.5rem': '88px',
  '5.625rem': '90px',
  '5.75rem': '92px',
  '5.875rem': '94px',
  '6rem': '96px',
  '7rem': '112px',
  '7.25rem': '116px',
  '7.5rem': '120px',
  '7.75rem': '124px',
  '8rem': '128px',
  '9rem': '144px',
  '10rem': '160px',
  '11rem': '176px',
  '11.25rem': '180px',
  '11.5rem': '184px',
  '11.75rem': '188px',
  '12rem': '192px',
  '13rem': '208px',
  '14rem': '224px',
  '15rem': '240px',
  '16rem': '256px',
  '18rem': '288px',
  '20rem': '320px',
  '24rem': '384px',
  '28rem': '448px',
  '32rem': '512px',
  '36rem': '576px',
  '42rem': '672px',
  '48rem': '768px',
  '56rem': '896px',
  '64rem': '1024px',
  '72rem': '1152px',
  '80rem': '1280px',
}

module.exports = {
  theme: {
    columns: {
      '3xs': remPx['16rem'],
      '2xs': remPx['18rem'],
      xs: remPx['20rem'],
      sm: remPx['24rem'],
      md: remPx['28rem'],
      lg: remPx['32rem'],
      xl: remPx['36rem'],
      '2xl': remPx['42rem'],
      '3xl': remPx['48rem'],
      '4xl': remPx['56rem'],
      '5xl': remPx['64rem'],
      '6xl': remPx['72rem'],
      '7xl': remPx['80rem'],
    },
    spacing: {
      0: remPx['0rem'],
      0.25: remPx['0.0625rem'],
      0.5: remPx['0.125rem'],
      0.75: remPx['0.1875rem'],
      1: remPx['0.25rem'],
      1.25: remPx['0.3125rem'],
      1.5: remPx['0.375rem'],
      1.75: remPx['0.4375rem'],
      2: remPx['0.5rem'],
      2.25: remPx['0.5625rem'],
      2.5: remPx['0.625rem'],
      2.75: remPx['0.6875rem'],
      3: remPx['0.75rem'],
      3.25: remPx['0.8125rem'],
      3.5: remPx['0.875rem'],
      3.75: remPx['0.9375rem'],
      4: remPx['1rem'],
      5: remPx['1.25rem'],
      6: remPx['1.5rem'],
      7: remPx['1.75rem'],
      8: remPx['2rem'],
      9: remPx['2.25rem'],
      10: remPx['2.5rem'],
      11: remPx['2.75rem'],
      12: remPx['3rem'],
      14: remPx['3.5rem'],
      16: remPx['4rem'],
      20: remPx['5rem'],
      20.5: remPx['5.125rem'],
      21: remPx['5.25rem'],
      21.5: remPx['5.375rem'],
      22: remPx['5.5rem'],
      22.5: remPx['5.625rem'],
      23: remPx['5.75rem'],
      23.5: remPx['5.875rem'],
      24: remPx['6rem'],
      28: remPx['7rem'],
      29: remPx['7.25rem'],
      30: remPx['7.5rem'],
      31: remPx['7.75rem'],
      32: remPx['8rem'],
      36: remPx['9rem'],
      40: remPx['10rem'],
      44: remPx['11rem'],
      45: remPx['11.25rem'],
      46: remPx['11.5rem'],
      47: remPx['11.75rem'],
      48: remPx['12rem'],
      52: remPx['13rem'],
      56: remPx['14rem'],
      60: remPx['15rem'],
      64: remPx['16rem'],
      72: remPx['18rem'],
      80: remPx['20rem'],
      96: remPx['24rem'],
    },
    borderRadius: {
      sm: remPx['0.125rem'],
      DEFAULT: remPx['0.25rem'],
      md: remPx['0.375rem'],
      lg: remPx['0.5rem'],
      xl: remPx['0.75rem'],
      '2xl': remPx['1rem'],
      '3xl': remPx['1.5rem'],
    },
    fontSize: {
      xs: [remPx['0.75rem'], { lineHeight: remPx['1rem'] }],
      sm: [remPx['0.875rem'], { lineHeight: remPx['1.25rem'] }],
      'md-sm': [remPx['0.9375rem'], { lineHeight: remPx['1.375rem']}],
      base: [remPx['1rem'], { lineHeight: remPx['1.5rem'] }],
      'md-lg': [remPx['1.0625rem'], {lineHeight: remPx['1.625rem']}],
      lg: [remPx['1.125rem'], { lineHeight: remPx['1.75rem'] }],
      xl: [remPx['1.25rem'], { lineHeight: remPx['1.75rem'] }],
      '2xl': [remPx['1.5rem'], { lineHeight: remPx['2rem'] }],
      '3xl': [remPx['1.875rem'], { lineHeight: remPx['2.25rem'] }],
      '4xl': [remPx['2.25rem'], { lineHeight: remPx['2.5rem'] }],
      '5xl': [remPx['3rem'], { lineHeight: '1' }],
      '6xl': [remPx['3.75rem'], { lineHeight: '1' }],
      '7xl': [remPx['4.5rem'], { lineHeight: '1' }],
      '8xl': [remPx['6rem'], { lineHeight: '1' }],
      '9xl': [remPx['8rem'], { lineHeight: '1' }],
    },
    lineHeight: {
      3: remPx['.75rem'],
      3.25: remPx['0.8125rem'],
      3.5: remPx['0.875rem'],
      3.75: remPx['0.9375rem'],
      4: remPx['1rem'],
      4.25: remPx['1.0625rem'],
      4.5: remPx['1.125rem'],
      4.75: remPx['1.1875rem'],
      5: remPx['1.25rem'],
      5.25: remPx['1.3125rem'],
      5.5: remPx['1.375rem'],
      5.75: remPx['1.4375rem'],
      6: remPx['1.5rem'],
      7: remPx['1.75rem'],
      8: remPx['2rem'],
      9: remPx['2.25rem'],
      10: remPx['2.5rem'],
    },
    maxWidth: ({ theme, breakpoints }) => ({
      0: remPx['0rem'],
      xs: remPx['20rem'],
      sm: remPx['24rem'],
      md: remPx['28rem'],
      lg: remPx['32rem'],
      xl: remPx['36rem'],
      '2xl': remPx['42rem'],
      '3xl': remPx['48rem'],
      '4xl': remPx['56rem'],
      '5xl': remPx['64rem'],
      '6xl': remPx['72rem'],
      '7xl': remPx['80rem'],
    }),
  }
};
