"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SnappedToVersionGroup = void 0;
const effect_1 = require("effect");
const report_1 = require("../report");
const specifier_1 = require("../specifier");
const group_by_1 = require("./lib/group-by");
class SnappedToVersionGroup extends effect_1.Data.TaggedClass('SnappedTo') {
    groupType = 'versionGroup';
    constructor(config) {
        super({
            config,
            instances: [],
        });
    }
    canAdd(_) {
        return true;
    }
    inspectAll() {
        return effect_1.Effect.all(Object.entries((0, group_by_1.groupBy)('name', this.instances)).flatMap(([name, instances]) => (0, effect_1.pipe)(findSnappedToInstance(name, this.config.snapTo, instances), effect_1.Effect.matchEffect({
            onFailure: () => effect_1.Effect.succeed(instances.map((instance) => 
            // ✘ none of the snapTo packages contain this dependency
            // ✘ is a user configuration error we can't auto-fix
            new report_1.Report.MissingSnappedToMismatch(instance))),
            onSuccess: (expected) => (0, effect_1.pipe)(instances, effect_1.Effect.forEach((instance) => (0, effect_1.pipe)(effect_1.Effect.Do, effect_1.Effect.bind('specifier', () => effect_1.Effect.succeed(specifier_1.Specifier.create(instance, instance.rawSpecifier.raw))), effect_1.Effect.bind('expected', () => effect_1.Effect.succeed(specifier_1.Specifier.create(instance, expected.rawSpecifier.raw))), effect_1.Effect.flatMap(({ expected, specifier }) => (0, effect_1.pipe)(expected.getSemver(), effect_1.Effect.matchEffect({
                onFailure: () => (0, effect_1.pipe)(specifier.replaceWith(expected), specifier.instance.semverGroup.getFixed, effect_1.Effect.match({
                    onFailure: () => 
                    // ✘ expected version is not semver
                    // ✘ semver group expects semver
                    // ✘ is a mismatch we can't auto-fix
                    new report_1.Report.UnsupportedMismatch(specifier.instance),
                    onSuccess: (valid) => specifier.instance.rawSpecifier.raw === valid.raw
                        ? // ! expected version is not semver
                            // ✓ semver group is disabled/ignored
                            // ✓ current version matches expected
                            new report_1.Report.Valid(specifier)
                        : // ! expected version is not semver
                            // ✓ semver group is disabled/ignored
                            // ✘ current version mismatches expected
                            // ✓ is a mismatch we can auto-fix by replacing with the non-semver version
                            new report_1.Report.SnappedToMismatch(valid, expected.instance),
                })),
                onSuccess: () => (0, effect_1.pipe)(specifier.replaceWith(expected), specifier.instance.semverGroup.getFixed, effect_1.Effect.match({
                    onFailure: /* istanbul ignore next */ () => 
                    // ✓ expected version is semver
                    // ✘ expected version is not fixable by its semver group
                    // ✘ is a mismatch we can't auto-fix
                    // ✘ this should be impossible - we already proved the local version is exact semver
                    new report_1.Report.UnsupportedMismatch(specifier.instance),
                    onSuccess: (valid) => specifier.instance.rawSpecifier.raw === valid.raw
                        ? // ✓ expected version is semver
                            // ✓ expected version matches its semver group
                            // ✓ current version matches expected
                            new report_1.Report.Valid(specifier)
                        : // ✓ expected version is semver
                            // ✓ expected version matches its semver group
                            // ✘ current version mismatches expected
                            // ✓ is a mismatch we can auto-fix
                            new report_1.Report.SnappedToMismatch(valid, expected.instance),
                })),
            })))))),
        }), effect_1.Effect.map((reports) => ({ name, reports })))));
    }
}
exports.SnappedToVersionGroup = SnappedToVersionGroup;
function findSnappedToInstance(name, snapTo, instances) {
    for (const instance of instances) {
        if (snapTo.includes(instance.pkgName) && instance.rawSpecifier.raw) {
            return (0, effect_1.pipe)(effect_1.Effect.succeed(instance), effect_1.Effect.tap(() => effect_1.Effect.logDebug(`found snapped to version ${String(instance.rawSpecifier.raw)} for ${name} in <${instance.packageJsonFile.jsonFile.shortPath}>`)));
        }
    }
    return (0, effect_1.pipe)(effect_1.Effect.fail('getSnappedTo found nothing'), effect_1.Effect.tapError(() => effect_1.Effect.logError(`failed to get snapped to version for ${name} using ${JSON.stringify(snapTo)}`)));
}
