"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SameRangeVersionGroup = void 0;
const effect_1 = require("effect");
const intersects_1 = __importDefault(require("semver/ranges/intersects"));
const uniq_1 = require("tightrope/array/uniq");
const report_1 = require("../report");
const specifier_1 = require("../specifier");
const group_by_1 = require("./lib/group-by");
class SameRangeVersionGroup extends effect_1.Data.TaggedClass('SameRange') {
    groupType = 'versionGroup';
    constructor(ctx, config) {
        super({
            ctx,
            config,
            instances: [],
        });
    }
    canAdd(_) {
        return true;
    }
    inspectAll() {
        return effect_1.Effect.all(Object.entries((0, group_by_1.groupBy)('name', this.instances)).flatMap(([name, instances]) => (0, effect_1.pipe)(instances, effect_1.Effect.partition((instance) => (0, effect_1.pipe)(effect_1.Effect.succeed(specifier_1.Specifier.create(instance, instance.rawSpecifier.raw)), effect_1.Effect.flatMap((specifier) => (0, effect_1.pipe)(specifier.getSemver(), effect_1.Effect.matchEffect({
            onFailure: () => effect_1.Effect.fail(
            // ✘ expected version is not semver
            // ✘ is a mismatch we can't auto-fix
            new report_1.Report.UnsupportedMismatch(specifier.instance)),
            onSuccess: () => (0, effect_1.pipe)(specifier.instance.semverGroup.getFixed(specifier), effect_1.Effect.matchEffect({
                onFailure: () => effect_1.Effect.fail(
                // ✓ expected version is semver
                // ✘ expected version is not fixable by its semver group
                // ✘ is a mismatch we can't auto-fix
                new report_1.Report.UnsupportedMismatch(specifier.instance)),
                onSuccess: (valid) => specifier.instance.rawSpecifier.raw === valid.raw
                    ? effect_1.Effect.succeed(
                    // ✓ expected version is semver
                    // ✓ expected version matches its semver group
                    // ✓ current version matches expected
                    new report_1.Report.Valid(specifier))
                    : effect_1.Effect.fail(
                    // ✓ expected version is semver
                    // ✓ expected version matches its semver group
                    // ✘ current version mismatches expected
                    // ✓ is a mismatch we can auto-fix
                    new report_1.Report.SemverRangeMismatch(valid)),
            })),
        }))))), effect_1.Effect.map(([allMismatches, allMatches]) => allMismatches.length === 0
            ? allMatches.map((thisMatch) => {
                if (thisMatch.specifier.instance.strategy.name === 'local') {
                    // ✓ every instance is valid on its own
                    // ✓ expected version is semver
                    // ! is the original local package
                    // ✓ others must match this, not the other way around
                    return thisMatch;
                }
                const mismatches = getRangeMismatches(this.ctx, thisMatch, allMatches);
                if (mismatches.length === 0) {
                    // ✓ every instance is valid on its own
                    // ✓ expected version is semver
                    // ✓ expected version matches its semver group
                    // ✓ current version matches expected
                    // ! is not the original local package
                    // ✓ current specifier matches every other specifier
                    return thisMatch;
                }
                // ✓ every instance is valid on its own
                // ✓ expected version is semver
                // ✓ expected version matches its semver group
                // ✓ current version matches expected
                // ! is not the original local package
                // ✘ current specifier does not match every other specifier
                return new report_1.Report.SameRangeMismatch(thisMatch.specifier.instance, (0, uniq_1.uniq)(mismatches.map((report) => String(report.specifier.instance.rawSpecifier.raw))));
            })
            : // ✘ not every instance is valid on its own
                // ! report on their validity individually ! when all are valid
                //   they can progress to being checked for having compatible
                //   ranges
                [...allMatches, ...allMismatches]), effect_1.Effect.map((reports) => ({ name, reports })))));
    }
}
exports.SameRangeVersionGroup = SameRangeVersionGroup;
/** Find all ranges/versions which this semver version does not cover */
function getRangeMismatches(ctx, report, others) {
    return others.filter((other) => !matchesRange(ctx, report, other));
}
/** Does semver version `a` match semver version `b`? */
function matchesRange(ctx, a, b) {
    const loose = true;
    return (0, intersects_1.default)(unwrapSemver(ctx, a.specifier), unwrapSemver(ctx, b.specifier), loose);
}
/** Get the semver version synchronously from a specifier known to contain semver */
function unwrapSemver(ctx, specifier) {
    if (specifier._tag === 'Range' || specifier._tag === 'Exact') {
        return specifier.raw;
    }
    if (specifier._tag === 'WorkspaceProtocol') {
        return effect_1.Effect.runSync(specifier.getSemverEquivalent(ctx));
    }
    return effect_1.Effect.runSync(specifier.getSemver());
}
