"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PinnedVersionGroup = void 0;
const effect_1 = require("effect");
const report_1 = require("../report");
const specifier_1 = require("../specifier");
const group_by_1 = require("./lib/group-by");
class PinnedVersionGroup extends effect_1.Data.TaggedClass('Pinned') {
    groupType = 'versionGroup';
    constructor(config) {
        super({
            config,
            instances: [],
        });
    }
    canAdd(_) {
        return true;
    }
    inspectAll() {
        return effect_1.Effect.all(Object.entries((0, group_by_1.groupBy)('name', this.instances)).map(([name, instances]) => (0, effect_1.pipe)(instances, effect_1.Effect.forEach((instance) => (0, effect_1.pipe)(effect_1.Effect.succeed(specifier_1.Specifier.create(instance, this.config.pinVersion)), effect_1.Effect.map((expected) => instance.rawSpecifier.raw === expected.raw
            ? // ✓ pinned takes precedence over any semver group
                // ✓ current version matches expected
                new report_1.Report.Valid(expected)
            : // ✓ pinned takes precedence over any semver group
                // ✘ current version mismatches expected
                // ✓ is a mismatch we can auto-fix
                new report_1.Report.PinnedMismatch(expected)))), effect_1.Effect.map((reports) => ({ name, reports })))));
    }
}
exports.PinnedVersionGroup = PinnedVersionGroup;
