"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.groupBy = void 0;
/**
 * Convert an array of objects to an object, where each property of the new
 * object is an array whose members share the same value for the given key.
 */
function groupBy(key, array) {
    return array.reduce((objectsByKeyValue, obj) => {
        const value = obj[key];
        objectsByKeyValue[value] = (objectsByKeyValue[value] || []).concat(obj);
        return objectsByKeyValue;
    }, {});
}
exports.groupBy = groupBy;
