"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getRangeScore = void 0;
const constants_1 = require("../../constants");
const scoresByRange = {
    [constants_1.RANGE.ANY]: 9,
    [constants_1.RANGE.WORKSPACE]: 8,
    [constants_1.RANGE.GT]: 7,
    [constants_1.RANGE.GTE]: 6,
    [constants_1.RANGE.MINOR]: 5,
    [constants_1.RANGE.LOOSE]: 4,
    [constants_1.RANGE.PATCH]: 3,
    [constants_1.RANGE.EXACT]: 2,
    [constants_1.RANGE.LTE]: 1,
    [constants_1.RANGE.LT]: 0,
};
/** Rank a Semver Range according to its greediness */
function getRangeScore(version) {
    const range = version.indexOf('.x') !== -1 ? constants_1.RANGE.LOOSE : version.slice(0, version.search(/[0-9]/));
    return scoresByRange[range] || 0;
}
exports.getRangeScore = getRangeScore;
