"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getPreferredVersion = void 0;
const effect_1 = require("effect");
const gt_1 = __importDefault(require("semver/functions/gt"));
const lt_1 = __importDefault(require("semver/functions/lt"));
const clean_1 = require("./clean");
const get_range_score_1 = require("./get-range-score");
function getPreferredVersion(preferVersion, specifiers) {
    return (0, effect_1.pipe)(
    // every instance must have a semver version
    effect_1.Effect.all(specifiers.map((specifier) => (0, effect_1.pipe)(specifier.getSemver(), effect_1.Effect.map((semver) => ({ semver, specifier }))))), 
    // comparing semver can error on some loose ranges, all must succeed
    effect_1.Effect.map((semvers) => semvers.sort((a, b) => compareSemver(a.semver, b.semver))), 
    // get the preferred value from the list
    effect_1.Effect.map((sorted) => sorted[preferVersion === 'lowestSemver' ? 0 : sorted.length - 1]), 
    // return just the specifier
    effect_1.Effect.map((preferred) => preferred?.specifier));
}
exports.getPreferredVersion = getPreferredVersion;
const EQ = 0;
const LT = -1;
const GT = 1;
function compareSemver(a, b) {
    if (a.startsWith('workspace:'))
        return LT;
    if (b.startsWith('workspace:'))
        return GT;
    if (a === b)
        return EQ;
    if (a === '*')
        return GT;
    if (b === '*')
        return LT;
    const cleanA = (0, clean_1.clean)(a);
    const cleanB = (0, clean_1.clean)(b);
    if ((0, gt_1.default)(cleanA, cleanB))
        return GT;
    if ((0, lt_1.default)(cleanA, cleanB))
        return LT;
    const scoreA = (0, get_range_score_1.getRangeScore)(a);
    const scoreB = (0, get_range_score_1.getRangeScore)(b);
    if (scoreA < scoreB)
        return LT;
    if (scoreA > scoreB)
        return GT;
    return EQ;
}
