"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IgnoredVersionGroup = void 0;
const effect_1 = require("effect");
const report_1 = require("../report");
const group_by_1 = require("./lib/group-by");
class IgnoredVersionGroup extends effect_1.Data.TaggedClass('Ignored') {
    groupType = 'versionGroup';
    constructor(config) {
        super({
            config,
            instances: [],
        });
    }
    canAdd(_) {
        return true;
    }
    inspectAll() {
        return effect_1.Effect.succeed(Object.entries((0, group_by_1.groupBy)('name', this.instances)).map(([name, instances]) => ({
            name,
            reports: instances.map((instance) => 
            // ✓ is ignored and dismissed as valid
            new report_1.Report.Ignored(instance)),
        })));
    }
}
exports.IgnoredVersionGroup = IgnoredVersionGroup;
