"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FilteredOutVersionGroup = void 0;
const effect_1 = require("effect");
const get_filter_1 = require("../config/get-filter");
const report_1 = require("../report");
const group_by_1 = require("./lib/group-by");
class FilteredOutVersionGroup extends effect_1.Data.TaggedClass('FilteredOut') {
    groupType = 'versionGroup';
    constructor(ctx) {
        super({
            config: {
                dependencies: ['**'],
                dependencyTypes: ['**'],
                label: 'Filtered out',
                packages: ['**'],
            },
            filter: (0, get_filter_1.getFilter)(ctx.config),
            instances: [],
        });
    }
    canAdd(instance) {
        return instance.name.search(new RegExp(this.filter)) === -1;
    }
    inspectAll() {
        return effect_1.Effect.succeed(Object.entries((0, group_by_1.groupBy)('name', this.instances)).map(([name, instances]) => ({
            name,
            reports: instances.map((instance) => 
            // ✓ is ignored and dismissed as valid
            new report_1.Report.FilteredOut(instance)),
        })));
    }
}
exports.FilteredOutVersionGroup = FilteredOutVersionGroup;
