"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BannedVersionGroup = void 0;
const effect_1 = require("effect");
const report_1 = require("../report");
const specifier_1 = require("../specifier");
const delete_1 = require("./lib/delete");
const group_by_1 = require("./lib/group-by");
class BannedVersionGroup extends effect_1.Data.TaggedClass('Banned') {
    groupType = 'versionGroup';
    constructor(config) {
        super({
            config,
            instances: [],
        });
    }
    canAdd(_) {
        return true;
    }
    inspectAll() {
        return effect_1.Effect.succeed(Object.entries((0, group_by_1.groupBy)('name', this.instances)).map(([name, instances]) => ({
            name,
            reports: instances.map((instance) => 
            // ✘ package should not be used
            // ✓ is a mismatch we can auto-fix
            new report_1.Report.Banned(specifier_1.Specifier.create(instance, delete_1.DELETE))),
        })));
    }
}
exports.BannedVersionGroup = BannedVersionGroup;
