"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.VersionsByNameStrategy = void 0;
const effect_1 = require("effect");
const is_non_empty_object_1 = require("tightrope/guard/is-non-empty-object");
const get_1 = require("../lib/get");
const delete_1 = require("../version-group/lib/delete");
const getOptionOfNonEmptyObject = effect_1.Option.liftPredicate((is_non_empty_object_1.isNonEmptyObject));
class VersionsByNameStrategy {
    _tag = 'versionsByName';
    name;
    path;
    constructor(name, path) {
        this.name = name;
        this.path = path;
    }
    read(file) {
        return (0, effect_1.pipe)((0, get_1.get)(file.jsonFile.contents, ...this.path.split('.')), effect_1.Effect.flatMap((value) => getOptionOfNonEmptyObject(value)), effect_1.Effect.map((obj) => Object.entries(obj)), effect_1.Effect.tapError(() => effect_1.Effect.logDebug(`VersionsByNameStrategy#${this.name} found nothing at <${file.jsonFile.shortPath}>.${this.path}`)), 
        // if value is invalid, default to empty
        effect_1.Effect.catchAll(() => effect_1.Effect.succeed([])));
    }
    write(file, [name, version]) {
        const nextValue = version === delete_1.DELETE ? undefined : version;
        return (0, effect_1.pipe)((0, get_1.get)(file.jsonFile.contents, ...this.path.split('.')), effect_1.Effect.flatMap(getOptionOfNonEmptyObject), effect_1.Effect.flatMap((parent) => effect_1.Effect.try(() => {
            parent[name] = nextValue;
        })), effect_1.Effect.tapError(() => effect_1.Effect.logDebug(`strategy ${this._tag} with name ${this.name} failed to write to <${file.jsonFile.shortPath}>.${this.path}.${name}`)), effect_1.Effect.catchAll(() => effect_1.Effect.succeed(file)), effect_1.Effect.map(() => file));
    }
}
exports.VersionsByNameStrategy = VersionsByNameStrategy;
