"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UnnamedVersionStringStrategy = void 0;
const effect_1 = require("effect");
const is_non_empty_object_1 = require("tightrope/guard/is-non-empty-object");
const get_1 = require("../lib/get");
const delete_1 = require("../version-group/lib/delete");
const get_non_empty_string_prop_1 = require("./lib/get-non-empty-string-prop");
const getOptionOfNonEmptyObject = effect_1.Option.liftPredicate((is_non_empty_object_1.isNonEmptyObject));
class UnnamedVersionStringStrategy {
    _tag = 'version';
    name;
    path;
    constructor(name, path) {
        this.name = name;
        this.path = path;
    }
    read(file) {
        return (0, effect_1.pipe)(
        // get version prop
        (0, get_non_empty_string_prop_1.getNonEmptyStringProp)(this.path, file), 
        // if it is a non empty string, we can read it
        effect_1.Effect.map((version) => {
            const name = this.path.split('.').slice(-1).join('');
            return [[name, version]];
        }), effect_1.Effect.tapError(() => effect_1.Effect.logDebug(`UnnamedVersionStringStrategy#${this.name} found nothing at <${file.jsonFile.shortPath}>.${this.path}`)), 
        // if value is invalid, default to empty
        effect_1.Effect.catchAll(() => effect_1.Effect.succeed([])));
    }
    write(file, [, version]) {
        const { contents } = file.jsonFile;
        const isNestedPath = this.path.includes('.');
        const nextValue = version === delete_1.DELETE ? undefined : version;
        if (isNestedPath) {
            const fullPath = this.path.split('.');
            const pathToParent = fullPath.slice(0, fullPath.length - 1).join('.');
            const key = fullPath.slice(-1).join('');
            return (0, effect_1.pipe)((0, get_1.get)(contents, ...pathToParent.split('.')), effect_1.Effect.flatMap(getOptionOfNonEmptyObject), effect_1.Effect.flatMap((parent) => effect_1.Effect.try(() => {
                parent[key] = nextValue;
            })), effect_1.Effect.tapError(() => effect_1.Effect.logDebug(`strategy ${this._tag} with name ${this.name} failed to write to <${file.jsonFile.shortPath}>.${this.path}`)), effect_1.Effect.catchAll(() => effect_1.Effect.succeed(file)), effect_1.Effect.map(() => file));
        }
        else {
            return (0, effect_1.pipe)(getOptionOfNonEmptyObject(contents), effect_1.Effect.flatMap((parent) => effect_1.Effect.try(() => {
                parent[this.path] = nextValue;
            })), effect_1.Effect.tapError(() => effect_1.Effect.logDebug(`strategy ${this._tag} with name ${this.name} failed to write to <${file.jsonFile.shortPath}>.${this.path}`)), effect_1.Effect.catchAll(() => effect_1.Effect.succeed(file)), effect_1.Effect.map(() => file));
        }
    }
}
exports.UnnamedVersionStringStrategy = UnnamedVersionStringStrategy;
