"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.NamedVersionStringStrategy = void 0;
const effect_1 = require("effect");
const is_non_empty_object_1 = require("tightrope/guard/is-non-empty-object");
const is_non_empty_string_1 = require("tightrope/guard/is-non-empty-string");
const get_1 = require("../lib/get");
const delete_1 = require("../version-group/lib/delete");
const get_non_empty_string_prop_1 = require("./lib/get-non-empty-string-prop");
const getOptionOfNonEmptyString = effect_1.Option.liftPredicate(is_non_empty_string_1.isNonEmptyString);
const getOptionOfNonEmptyObject = effect_1.Option.liftPredicate((is_non_empty_object_1.isNonEmptyObject));
class NamedVersionStringStrategy {
    _tag = 'name@version';
    name;
    path;
    constructor(name, path) {
        this.name = name;
        this.path = path;
    }
    read(file) {
        const path = this.path;
        return (0, effect_1.pipe)(
        // get version prop
        (0, get_non_empty_string_prop_1.getNonEmptyStringProp)(path, file), 
        // if it is a non empty string, we can read it
        effect_1.Effect.map((value) => value.split(/@(.*)/)), 
        // check the string was properly formed
        effect_1.Effect.flatMap(([name, version]) => effect_1.Effect.all([getOptionOfNonEmptyString(name), getOptionOfNonEmptyString(version)])), 
        // return an array of one entry if valid
        effect_1.Effect.map(([name, version]) => [[name, version]]), effect_1.Effect.tapError(() => effect_1.Effect.logDebug(`NamedVersionStringStrategy#${this.name} found nothing at <${file.jsonFile.shortPath}>.${this.path}`)), 
        // if value is invalid, default to empty
        effect_1.Effect.catchAll(() => effect_1.Effect.succeed([])));
    }
    write(file, [name, version]) {
        const { contents } = file.jsonFile;
        const isNestedPath = this.path.includes('.');
        const nextValue = version === delete_1.DELETE ? undefined : `${name}@${version}`;
        if (isNestedPath) {
            const fullPath = this.path.split('.');
            const pathToParent = fullPath.slice(0, fullPath.length - 1).join('.');
            const key = fullPath.slice(-1).join('');
            return (0, effect_1.pipe)((0, get_1.get)(contents, ...pathToParent.split('.')), effect_1.Effect.flatMap(getOptionOfNonEmptyObject), effect_1.Effect.flatMap((parent) => effect_1.Effect.try(() => {
                parent[key] = nextValue;
            })), effect_1.Effect.tapError(() => effect_1.Effect.logDebug(`strategy ${this._tag} with name ${this.name} failed to write to <${file.jsonFile.shortPath}>.${this.path}`)), effect_1.Effect.catchAll(() => effect_1.Effect.succeed(file)), effect_1.Effect.map(() => file));
        }
        else {
            return (0, effect_1.pipe)(getOptionOfNonEmptyObject(contents), effect_1.Effect.flatMap((parent) => effect_1.Effect.try(() => {
                parent[this.path] = nextValue;
            })), effect_1.Effect.tapError(() => effect_1.Effect.logDebug(`strategy ${this._tag} with name ${this.name} failed to write to <${file.jsonFile.shortPath}>.${this.path}`)), effect_1.Effect.catchAll(() => effect_1.Effect.succeed(file)), effect_1.Effect.map(() => file));
        }
    }
}
exports.NamedVersionStringStrategy = NamedVersionStringStrategy;
