"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.NameAndVersionPropsStrategy = void 0;
const effect_1 = require("effect");
const is_object_1 = require("tightrope/guard/is-object");
const get_1 = require("../lib/get");
const delete_1 = require("../version-group/lib/delete");
const get_non_empty_string_prop_1 = require("./lib/get-non-empty-string-prop");
const getOptionOfObject = effect_1.Option.liftPredicate((is_object_1.isObject));
class NameAndVersionPropsStrategy {
    _tag = 'name~version';
    name;
    path;
    namePath;
    constructor(name, path, namePath) {
        this.name = name;
        this.path = path;
        this.namePath = namePath;
    }
    read(file) {
        return (0, effect_1.pipe)(effect_1.Effect.Do, 
        // get the name prop
        effect_1.Effect.bind('name', () => (0, get_non_empty_string_prop_1.getNonEmptyStringProp)(this.namePath, file)), 
        // add the version prop
        effect_1.Effect.bind('version', () => (0, effect_1.pipe)((0, get_non_empty_string_prop_1.getNonEmptyStringProp)(this.path, file), 
        /**
         * In order to report a `MissingLocalVersion`, we need to ensure that
         * a value is returned for `local` package .version properties so we
         * can know that `this.name` is a package developed in this repo but
         * that its version is missing.
         *
         * Not doing this results in the invalid local package being ignored
         * and each installation of it being checked for mismatches amongst
         * themselves.
         */
        this.name === 'local'
            ? effect_1.Effect.catchAll(() => effect_1.Effect.succeed('PACKAGE_JSON_HAS_NO_VERSION'))
            : effect_1.Effect.map(effect_1.identity))), 
        // if both are non empty strings, we can return them
        effect_1.Effect.map(({ name, version }) => [[name, version]]), effect_1.Effect.tapError(() => effect_1.Effect.logDebug(`NameAndVersionPropsStrategy#${this.name} found nothing at <${file.jsonFile.shortPath}>.${this.path} & .${this.namePath}`)), 
        // if either are invalid, default to empty
        effect_1.Effect.catchAll(() => effect_1.Effect.succeed([])));
    }
    write(file, [, version]) {
        const path = this.path;
        const { contents } = file.jsonFile;
        const isNestedPath = path.includes('.');
        const nextValue = version === delete_1.DELETE ? undefined : version;
        if (isNestedPath) {
            const fullPath = path.split('.');
            const pathToParent = fullPath.slice(0, fullPath.length - 1).join('.');
            const key = fullPath.slice(-1).join('');
            return (0, effect_1.pipe)((0, get_1.get)(contents, ...pathToParent.split('.')), effect_1.Effect.flatMap(getOptionOfObject), effect_1.Effect.flatMap((parent) => effect_1.Effect.try(() => {
                parent[key] = nextValue;
            })), effect_1.Effect.tapError(() => effect_1.Effect.logDebug(`strategy ${this._tag} with name ${this.name} failed to write to <${file.jsonFile.shortPath}>.${this.path}`)), effect_1.Effect.catchAll(() => effect_1.Effect.succeed(file)), effect_1.Effect.map(() => file));
        }
        else {
            return (0, effect_1.pipe)(getOptionOfObject(contents), effect_1.Effect.flatMap((parent) => effect_1.Effect.try(() => {
                parent[this.path] = nextValue;
            })), effect_1.Effect.tapError(() => effect_1.Effect.logDebug(`strategy ${this._tag} with name ${this.name} failed to write to <${file.jsonFile.shortPath}>.${this.path}`)), effect_1.Effect.catchAll(() => effect_1.Effect.succeed(file)), effect_1.Effect.map(() => file));
        }
    }
}
exports.NameAndVersionPropsStrategy = NameAndVersionPropsStrategy;
