"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getNonEmptyStringProp = void 0;
const effect_1 = require("effect");
const is_non_empty_string_1 = require("tightrope/guard/is-non-empty-string");
const get_1 = require("../../lib/get");
const getOptionOfNonEmptyString = effect_1.Option.liftPredicate(is_non_empty_string_1.isNonEmptyString);
function getNonEmptyStringProp(propPath, file) {
    return (0, effect_1.pipe)((0, get_1.get)(file.jsonFile.contents, ...propPath.split('.')), effect_1.Effect.flatMap((value) => getOptionOfNonEmptyString(value)), effect_1.Effect.tapError(() => effect_1.Effect.logDebug(`<${file.jsonFile.shortPath}>.${propPath} is not a non-empty string`)));
}
exports.getNonEmptyStringProp = getNonEmptyStringProp;
