"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.WorkspaceProtocolSpecifier = void 0;
const effect_1 = require("effect");
const _1 = require(".");
const base_1 = require("./base");
/** Represents "workspace:*" and "workspace:~" */
class WorkspaceProtocolSpecifier extends base_1.BaseSpecifier {
    _tag = 'WorkspaceProtocol';
    /** The public name referenced in config */
    name = 'workspace-protocol';
    /**
     * Return an equivalent value which actually is semver, so that it can be used
     * with tools which expect values which conform to the spec. This value is
     * used only when sorting versions.
     */
    getSemverEquivalent(ctx) {
        if (this.raw === 'workspace:*') {
            return effect_1.Effect.succeed('*');
        }
        if (this.raw === 'workspace:~' || this.raw === 'workspace:^') {
            const range = this.raw.replace('workspace:', '');
            const local = ctx.packageJsonFilesByName[this.instance.name];
            const version = local?.jsonFile?.contents?.version;
            if (version)
                return effect_1.Effect.succeed(`${range}${version}`);
        }
        return effect_1.Effect.succeed('0.0.0');
    }
    // @TODO: this name is inaccurate, check how it is used and change logic or rename
    getSemver() {
        return effect_1.Effect.succeed(this.raw);
    }
    setSemver(version) {
        return effect_1.Effect.succeed(_1.Specifier.create(this.instance, version));
    }
}
exports.WorkspaceProtocolSpecifier = WorkspaceProtocolSpecifier;
