import { Effect } from 'effect';
import { Specifier } from '.';
import type { Ctx } from '../get-context';
import { BaseSpecifier } from './base';
import type { WorkspaceProtocolResult } from './lib/parse-specifier';
/** Represents "workspace:*" and "workspace:~" */
export declare class WorkspaceProtocolSpecifier extends BaseSpecifier<WorkspaceProtocolResult> {
    _tag: string;
    /** The public name referenced in config */
    name: "workspace-protocol";
    /**
     * Return an equivalent value which actually is semver, so that it can be used
     * with tools which expect values which conform to the spec. This value is
     * used only when sorting versions.
     */
    getSemverEquivalent(ctx: Ctx): Effect.Effect<never, never, string>;
    getSemver(): Effect.Effect<never, never, string>;
    setSemver(version: string): Effect.Effect<never, never, Specifier.Any>;
}
