"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RangeSpecifier = void 0;
const effect_1 = require("effect");
const _1 = require(".");
const base_1 = require("./base");
const non_semver_error_1 = require("./lib/non-semver-error");
/**
 * @example "^1.2.3"
 */
class RangeSpecifier extends base_1.BaseSpecifier {
    _tag = 'Range';
    /** The public name referenced in config */
    name = 'range';
    /** Return the semver version including the range */
    getSemver() {
        return (0, effect_1.pipe)(this.parse(), effect_1.Effect.mapError(() => new non_semver_error_1.NonSemverError({ specifier: this })), effect_1.Effect.map((parsed) => parsed.fetchSpec));
    }
    /** Get a new `Specifier` from the given semver version applied to this one */
    setSemver(version) {
        return effect_1.Effect.succeed(_1.Specifier.create(this.instance, version));
    }
}
exports.RangeSpecifier = RangeSpecifier;
