import { Effect } from 'effect';
import { Specifier } from '.';
import { BaseSpecifier } from './base';
import { NonSemverError } from './lib/non-semver-error';
import type { SpecificRegistryResult } from './lib/specific-registry-result';
type T = SpecificRegistryResult<'range'>;
/**
 * @example "^1.2.3"
 */
export declare class RangeSpecifier extends BaseSpecifier<T> {
    _tag: string;
    /** The public name referenced in config */
    name: "range";
    /** Return the semver version including the range */
    getSemver(): Effect.Effect<never, NonSemverError, string>;
    /** Get a new `Specifier` from the given semver version applied to this one */
    setSemver(version: string): Effect.Effect<never, never, Specifier.Any>;
}
export {};
