"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseSpecifier = void 0;
const npm_package_arg_1 = __importDefault(require("npm-package-arg"));
function parseSpecifier(name, specifier, packageJsonFile) {
    if (specifier === 'workspace:*' || specifier === 'workspace:~' || specifier === 'workspace:^') {
        const parsed = npm_package_arg_1.default.resolve(name, packageJsonFile.jsonFile.dirPath, specifier.replace('workspace:', 'file:'));
        return {
            escapedName: parsed.escapedName,
            name: parsed.name,
            raw: parsed.raw.replace('file:', 'workspace:'),
            rawSpec: parsed.rawSpec.replace('file:', 'workspace:'),
            saveSpec: parsed.saveSpec.replace('file:', 'workspace:'),
            scope: parsed.scope,
            type: 'workspaceProtocol',
        };
    }
    return npm_package_arg_1.default.resolve(name, specifier, packageJsonFile.jsonFile.dirPath);
}
exports.parseSpecifier = parseSpecifier;
