"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Specifier = void 0;
const delete_1 = require("../version-group/lib/delete");
const alias_1 = require("./alias");
const delete_2 = require("./delete");
const exact_1 = require("./exact");
const file_1 = require("./file");
const hosted_git_1 = require("./hosted-git");
const latest_1 = require("./latest");
const parse_specifier_1 = require("./lib/parse-specifier");
const range_1 = require("./range");
const tag_1 = require("./tag");
const unsupported_1 = require("./unsupported");
const url_1 = require("./url");
const workspace_protocol_1 = require("./workspace-protocol");
var Specifier;
(function (Specifier) {
    Specifier.Alias = alias_1.AliasSpecifier;
    Specifier.Delete = delete_2.DeleteSpecifier;
    Specifier.Exact = exact_1.ExactSpecifier;
    Specifier.File = file_1.FileSpecifier;
    Specifier.HostedGit = hosted_git_1.HostedGitSpecifier;
    Specifier.Latest = latest_1.LatestSpecifier;
    Specifier.Range = range_1.RangeSpecifier;
    Specifier.Tag = tag_1.TagSpecifier;
    Specifier.Unsupported = unsupported_1.UnsupportedSpecifier;
    Specifier.Url = url_1.UrlSpecifier;
    Specifier.WorkspaceProtocol = workspace_protocol_1.WorkspaceProtocolSpecifier;
    function create(instance, raw) {
        if (raw === delete_1.DELETE)
            return new Specifier.Delete({ instance, raw });
        if (!raw)
            return new Specifier.Unsupported({ instance, raw });
        try {
            if (raw === 'latest')
                raw = '*';
            const parsed = (0, parse_specifier_1.parseSpecifier)(instance.name, raw, instance.packageJsonFile);
            const type = parsed.type;
            const data = { instance, raw };
            if (raw === '*')
                return new Specifier.Latest(data);
            if (type === 'version')
                return new Specifier.Exact(data);
            if (type === 'range')
                return new Specifier.Range(data);
            if (type === 'workspaceProtocol')
                return new Specifier.WorkspaceProtocol(data);
            if (type === 'alias')
                return new Specifier.Alias(data);
            if (type === 'file' || type === 'directory')
                return new Specifier.File(data);
            if (type === 'remote')
                return new Specifier.Url(data);
            if (type === 'git')
                return new Specifier.HostedGit(data);
            if (type === 'tag')
                return new Specifier.Tag(data);
            return new Specifier.Unsupported(data);
        }
        catch {
            return new Specifier.Unsupported({ instance, raw });
        }
    }
    Specifier.create = create;
})(Specifier || (exports.Specifier = Specifier = {}));
