import type { Instance } from '../get-instances/instance';
import { type Delete } from '../version-group/lib/delete';
import { AliasSpecifier } from './alias';
import { DeleteSpecifier } from './delete';
import { ExactSpecifier } from './exact';
import { FileSpecifier } from './file';
import { HostedGitSpecifier } from './hosted-git';
import { LatestSpecifier } from './latest';
import { RangeSpecifier } from './range';
import { TagSpecifier } from './tag';
import { UnsupportedSpecifier } from './unsupported';
import { UrlSpecifier } from './url';
import { WorkspaceProtocolSpecifier } from './workspace-protocol';
export declare namespace Specifier {
    const Alias: typeof AliasSpecifier;
    const Delete: typeof DeleteSpecifier;
    const Exact: typeof ExactSpecifier;
    const File: typeof FileSpecifier;
    const HostedGit: typeof HostedGitSpecifier;
    const Latest: typeof LatestSpecifier;
    const Range: typeof RangeSpecifier;
    const Tag: typeof TagSpecifier;
    const Unsupported: typeof UnsupportedSpecifier;
    const Url: typeof UrlSpecifier;
    const WorkspaceProtocol: typeof WorkspaceProtocolSpecifier;
    type Any = AliasSpecifier | DeleteSpecifier | ExactSpecifier | FileSpecifier | HostedGitSpecifier | LatestSpecifier | RangeSpecifier | TagSpecifier | UnsupportedSpecifier | UrlSpecifier | WorkspaceProtocolSpecifier;
    function create(instance: Instance, raw: string | Delete): Specifier.Any;
}
