"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.HostedGitSpecifier = void 0;
const effect_1 = require("effect");
const _1 = require(".");
const is_semver_1 = require("../guards/is-semver");
const base_1 = require("./base");
const non_semver_error_1 = require("./lib/non-semver-error");
/** @example "git+https://github.com/user/foo" */
class HostedGitSpecifier extends base_1.BaseSpecifier {
    _tag = 'HostedGit';
    /** The public name referenced in config */
    name = 'hosted-git';
    /** Return the git tag if it is valid semver */
    getSemver() {
        return (0, effect_1.pipe)(this.parse(), effect_1.Effect.mapError(() => new non_semver_error_1.NonSemverError({ specifier: this })), effect_1.Effect.map((parsed) => parsed.gitCommittish || ''), effect_1.Effect.flatMap((gitCommittish) => (0, is_semver_1.isSemver)(gitCommittish) ? effect_1.Effect.succeed(gitCommittish) : non_semver_error_1.NonSemverError.asEffect(this)));
    }
    /** Get a new `Specifier` from the given semver version applied to this one */
    setSemver(version) {
        return (0, effect_1.pipe)(this.parse(), effect_1.Effect.mapError(() => new non_semver_error_1.NonSemverError({ specifier: this })), effect_1.Effect.map((parsed) => ({
            gitCommittish: parsed.gitCommittish || '',
            rawSpec: parsed.rawSpec || '',
        })), effect_1.Effect.map(({ gitCommittish, rawSpec }) => rawSpec.replace(gitCommittish, version)), effect_1.Effect.map((raw) => _1.Specifier.create(this.instance, raw)));
    }
}
exports.HostedGitSpecifier = HostedGitSpecifier;
