import { Effect } from 'effect';
import type { HostedGitResult } from 'npm-package-arg';
import { Specifier } from '.';
import { BaseSpecifier } from './base';
import { NonSemverError } from './lib/non-semver-error';
/** @example "git+https://github.com/user/foo" */
export declare class HostedGitSpecifier extends BaseSpecifier<HostedGitResult> {
    _tag: string;
    /** The public name referenced in config */
    name: "hosted-git";
    /** Return the git tag if it is valid semver */
    getSemver(): Effect.Effect<never, NonSemverError, string>;
    /** Get a new `Specifier` from the given semver version applied to this one */
    setSemver(version: string): Effect.Effect<never, NonSemverError, Specifier.Any>;
}
